/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsOTelConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.NetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class NetServerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final InternalNetServerAttributesExtractor<REQUEST, RESPONSE> internalExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST, RESPONSE> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST, RESPONSE> internalClientExtractor;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(NetServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new NetServerAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private NetServerAttributesExtractor(NetServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.internalExtractor = new InternalNetServerAttributesExtractor<REQUEST, RESPONSE>(getter, FallbackAddressPortExtractor.noop(), SemconvStability.emitOldHttpSemconv());
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(getter, NetworkTransportFilter.alwaysTrue(), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.internalServerExtractor = new InternalServerAttributesExtractor<Object, RESPONSE>(getter, (port, request) -> true, FallbackAddressPortExtractor.noop(), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.HOST);
        this.internalClientExtractor = new InternalClientAttributesExtractor<REQUEST, RESPONSE>(getter, FallbackAddressPortExtractor.noop(), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            this.internalExtractor.onStart(attributes, request);
            this.internalServerExtractor.onStart(attributes, request);
            this.internalClientExtractor.onStart(attributes, request);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            this.internalNetworkExtractor.onEnd(attributes, request, response);
            this.internalServerExtractor.onEnd(attributes, request, response);
            this.internalClientExtractor.onEnd(attributes, request, response);
        }
    }
}

