/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.ArmsMessagingConsumerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.ArmsMessagingConsumerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public class ArmsMessagingConsumerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final ArmsMessagingConsumerAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ArmsMessagingConsumerAttributesGetter<REQUEST, RESPONSE> getter) {
        return ArmsMessagingConsumerAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> ArmsMessagingConsumerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(ArmsMessagingConsumerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new ArmsMessagingConsumerAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    public ArmsMessagingConsumerAttributesExtractor(ArmsMessagingConsumerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Long consumeDelayTime = this.getter.getConsumeDelayTime(response);
        if (consumeDelayTime != null && consumeDelayTime > 0L) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.MESSAGE_DELAY_MILLISECONDS_KEY, consumeDelayTime);
        }
    }
}

