/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ArmsHttpServerMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpMetricsUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.bootstrap.MseFeature;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public final class HttpServerMetrics
implements OperationListener {
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("http-server-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        if (ArmsState.INSTANCE.isArmsEnable() || MseFeature.isCloudProductMseEnable()) {
            return ArmsHttpServerMetrics.get();
        }
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = HttpMetricsUtil.createDurationHistogram(meter, "http.server.duration", "The duration of the inbound HTTP request");
        this.requestSize = meter.histogramBuilder("http.server.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.server.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, TemporaryMetricsView.applyActiveRequestsView(startAttributes), context);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        State state = context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, TemporaryMetricsView.applyActiveRequestsView(state.startAttributes()), context);
        Attributes durationAndSizeAttributes = TemporaryMetricsView.applyServerDurationAndSizeView(state.startAttributes(), endAttributes);
        this.duration.record(HttpMetricsUtil.nanosToUnit(endNanos - state.startTimeNanos()), durationAndSizeAttributes, context);
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, state.startAttributes());
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize, durationAndSizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, state.startAttributes())) != null) {
            this.responseSize.record(responseBodySize, durationAndSizeAttributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

