/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.LocalRootSpanUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteBiGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteSource;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class HttpRouteHolder {
    private static final ConvergeService convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);

    public static <REQUEST> ContextCustomizer<REQUEST> create(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return (context, request, startAttributes) -> {
            if (HttpRouteState.fromContextOrNull(context) != null) {
                return context;
            }
            String method = getter.getHttpRequestMethod(request);
            boolean shouldIgnore = ArmsRpcConfigState.rpcConfigState.shouldIgnoreByHttpMethod(method);
            if (shouldIgnore) {
                AliyunContextHolderUtils.putToAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_HTTP_METHOD_KEY.getKey(), true, context);
            }
            return context.with(HttpRouteState.create(method, "/*", 0));
        };
    }

    private HttpRouteHolder() {
    }

    public static void updateHttpRoute(Context context, HttpRouteSource source, @Nullable String httpRoute) {
        HttpRouteHolder.updateHttpRoute(context, source, ConstantAdapter.INSTANCE, httpRoute);
    }

    public static <T> void updateHttpRoute(Context context, HttpRouteSource source, HttpRouteGetter<T> httpRouteGetter, T arg1) {
        HttpRouteHolder.updateHttpRoute(context, source, OneArgAdapter.getInstance(), arg1, httpRouteGetter);
    }

    public static <T, U> void updateHttpRoute(Context context, HttpRouteSource source, HttpRouteBiGetter<T, U> httpRouteGetter, T arg1, U arg2) {
        String route;
        boolean onlyIfBetterRoute;
        Span serverSpan = LocalRootSpan.fromContextOrNull(context);
        if (serverSpan == null) {
            return;
        }
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        if (httpRouteState == null) {
            String httpRoute = httpRouteGetter.get(context, arg1, arg2);
            if (httpRoute != null && !httpRoute.isEmpty()) {
                httpRoute = HttpRouteHolder.convergeRpc(httpRoute);
                serverSpan.setAttribute(SemanticAttributes.HTTP_ROUTE, httpRoute);
            }
            return;
        }
        boolean bl = onlyIfBetterRoute = !source.useFirst && source.order == httpRouteState.getUpdatedBySourceOrder();
        if (!(source.order <= httpRouteState.getUpdatedBySourceOrder() && !onlyIfBetterRoute || (route = httpRouteGetter.get(context, arg1, arg2)) == null || route.isEmpty() || onlyIfBetterRoute && !HttpRouteHolder.isBetterRoute(httpRouteState, route))) {
            route = HttpRouteHolder.convergeRpc(route);
            HttpRouteHolder.updateSpanName(serverSpan, httpRouteState, route);
            httpRouteState.update(context, source.order, route);
        }
    }

    private static boolean isBetterRoute(HttpRouteState httpRouteState, String name) {
        String route = httpRouteState.getRoute();
        int routeLength = route == null ? 0 : route.length();
        return name.length() > routeLength;
    }

    private static void updateSpanName(Span serverSpan, HttpRouteState httpRouteState, String route) {
        LocalRootSpanUpdater.updateSpanName(serverSpan, route);
    }

    static String convergeRpc(String route) {
        if (convergeService == null || route.endsWith("*")) {
            return route;
        }
        return convergeService.convergeRpc(UniCallKind.HTTP, route);
    }

    @Nullable
    static String getRoute(Context context) {
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        return httpRouteState == null ? null : httpRouteState.getRoute();
    }

    private static final class ConstantAdapter
    implements HttpRouteGetter<String> {
        private static final ConstantAdapter INSTANCE = new ConstantAdapter();

        private ConstantAdapter() {
        }

        @Override
        @Nullable
        public String get(Context context, String route) {
            return route;
        }
    }

    private static final class OneArgAdapter<T>
    implements HttpRouteBiGetter<T, HttpRouteGetter<T>> {
        private static final OneArgAdapter<Object> INSTANCE = new OneArgAdapter();

        private OneArgAdapter() {
        }

        static <T> OneArgAdapter<T> getInstance() {
            return INSTANCE;
        }

        @Override
        @Nullable
        public String get(Context context, T arg, HttpRouteGetter<T> httpRouteGetter) {
            return httpRouteGetter.get(context, arg);
        }
    }
}

