/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ArmsHttpServerMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<ArmsHttpServerMetricsState> ARMS_HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("arms-http-server-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerMetrics.class.getName());

    public static OperationMetrics get() {
        return ArmsHttpServerMetrics::new;
    }

    private ArmsHttpServerMetrics(Meter meter) {
        super(meter);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_HTTP_SERVER_REQUEST_METRICS_STATE, new ArmsHttpServerMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        ArmsHttpServerMetricsState state = context.get(ARMS_HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.totalRequestCount.add(1L, endAttributes, context);
        double duration = (double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS;
        this.requestDuration.add((long)duration, endAttributes, context);
        this.statusRequestCount.add(1L, endAttributes);
        if (ArmsAttributesConvertUtil.hasError(context, endAttributes)) {
            this.errorRequestCount.add(1L, endAttributes);
            Span.fromContext(context).setStatus(StatusCode.ERROR);
        }
        if (ArmsAttributesConvertUtil.isSlowInterface(duration)) {
            this.slowRequestCount.add(1L, endAttributes);
        }
        String callType = endAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY);
        String callKind = endAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY);
        Long rpcType = endAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS);
        if (StringUtils.isEmpty(callKind) || StringUtils.isEmpty(callType) || rpcType == null) {
            return;
        }
        this.recordInCallQuantileMetrics(callKind, callType, rpcType, endAttributes, (long)duration);
    }

    static class ArmsHttpServerMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsHttpServerMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

