/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.dto.ArmsPair;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.tag.TagService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.ArmsCommonUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsOTelConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsServiceTypeFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsSqlConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.db.ArmsProcessedSql;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.db.ArmsSqlRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.ArmsDbClientMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.DbClientCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.logging.Level;
import javax.annotation.Nullable;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final PatchLogger logger = PatchLogger.getLogger(DbClientCommonAttributesExtractor.class.getName());
    private static final SqlStatementSanitizer sanitizer = SqlStatementSanitizer.create(true);
    final GETTER getter;
    final ConvergeService convergeService;
    final ArmsSqlRecorder sqlRecordInstance;
    private TagService tagService;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
        this.convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
        this.sqlRecordInstance = GlobalInstanceHolder.getInstance(ArmsSqlRecorder.class);
        try {
            this.tagService = GlobalInstanceHolder.getInstance(TagService.class);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to get tag service", t);
        }
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String system;
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_SYSTEM, this.getter.getSystem(request));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_USER, this.getter.getUser(request));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_NAME, this.getter.getName(request));
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_CONNECTION_STRING, this.getter.getConnectionString(request));
        }
        if ((system = this.getter.getSystem(request)) != null && ArmsAttributesConvertUtil.supportDBSystem.containsKey(system.toLowerCase())) {
            ArmsPair<ArmsRpcTypeEnum, ArmsServiceTypeFactory.ArmsServiceType> pair = ArmsAttributesConvertUtil.supportDBSystem.get(system.toLowerCase());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.COMPONENT_NAME_KEY, ((ArmsRpcTypeEnum)((Object)pair.first)).getName());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, ((ArmsRpcTypeEnum)((Object)pair.first)).getCode().longValue());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY, Long.valueOf(((ArmsRpcTypeEnum)((Object)pair.first)).ordinal()));
        }
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.DB_NAME, this.getter.getDestId(request));
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.DB_ENDPOINT, this.getter.getEndPoint(request));
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.DB_BIND_VALUE_KEY, this.getter.getBindValues(request));
        if (this.getter.getArgs(request) != null && this.getter.getArgs(request).length() > 0) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.REDIS_COMMAND_KEY, this.getter.getArgs(request));
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        String system = this.getter.getSystem(request);
        if (system != null && ArmsAttributesConvertUtil.supportDBSystem.containsKey(system.toLowerCase())) {
            ArmsPair<ArmsRpcTypeEnum, ArmsServiceTypeFactory.ArmsServiceType> pair = ArmsAttributesConvertUtil.supportDBSystem.get(system.toLowerCase());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.SERVER_TYPE_KEY, ((ArmsServiceTypeFactory.ArmsServiceType)pair.second).getCode().longValue());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, ((ArmsRpcTypeEnum)((Object)pair.first)).getCode().longValue());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY, Long.valueOf(((ArmsRpcTypeEnum)((Object)pair.first)).ordinal()));
        }
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.DEST_ID_KEY, this.getter.getDestId(request));
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.ENDPOINT_KEY, this.getter.getEndPoint(request));
        if (this.getter.getRequestSize(request) != null && !ArmsConstants.LongKeys.INVALID_REQUEST_RESPONSE_SIZE.equals(this.getter.getRequestSize(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.REQUEST_SIZE_KEY, this.getter.getRequestSize(request));
        }
        if (this.getter.getResponseSize(request) != null && !ArmsConstants.LongKeys.INVALID_REQUEST_RESPONSE_SIZE.equals(this.getter.getResponseSize(request))) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RESPONSE_SIZE_KEY, this.getter.getResponseSize(request));
        }
        String sql = this.getter.getSql(request);
        String[] truncatedAndConvergenceSql = this.truncateAndConvergeSql(context, sql);
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.SQL_KEY, truncatedAndConvergenceSql[0]);
        if (this.sqlRecordInstance != null) {
            ArmsProcessedSql armsProcessedSql = this.sqlRecordInstance.recordSql(truncatedAndConvergenceSql[1]);
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.SQL_ID_KEY, armsProcessedSql.getSqlId());
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.DB_STATEMENT_ID_KEY, armsProcessedSql.getSqlId());
        }
    }

    private String[] truncateAndConvergeSql(Context context, String sql) {
        if (StringUtils.isEmpty(sql)) {
            return new String[]{"", ""};
        }
        String truncatedSql = ArmsCommonUtils.newAbbreviate(sql, ArmsSqlConfigState.configState.getSqlMaxLength());
        SqlStatementInfo statementInfo = sanitizer.sanitize(truncatedSql);
        String convergenceSql = truncatedSql;
        if (!ArmsSqlConfigState.configState.isRawSql() && !StringUtils.isEmpty(statementInfo.getFullStatement())) {
            convergenceSql = statementInfo.getFullStatement();
        }
        if (ArmsSqlConfigState.configState.isConvergeTableName()) {
            convergenceSql = this.convergenceTableName(convergenceSql, statementInfo.getMainIdentifier());
        }
        if (this.convergeService != null) {
            long cost;
            Long startMills = ArmsDbClientMetrics.getDbSpanStartMills(context);
            boolean isSlow = false;
            if (startMills != null && ArmsAttributesConvertUtil.isSlowSql(cost = System.currentTimeMillis() - startMills)) {
                isSlow = true;
            }
            convergenceSql = isSlow ? this.convergeService.convergeSlowSql(convergenceSql) : this.convergeService.convergeSql(convergenceSql);
        }
        return new String[]{truncatedSql, convergenceSql};
    }

    private String convergenceTableName(String sql, String tableName) {
        String tableNameSuffix;
        if (StringUtils.isEmpty(tableName) || StringUtils.isEmpty(sql)) {
            return sql;
        }
        int underlineIndex = -1;
        underlineIndex = tableName.lastIndexOf(95);
        if (underlineIndex > 0 && StringUtils.isNumeric(tableNameSuffix = tableName.substring(underlineIndex + 1))) {
            int tableStartIndex = sql.indexOf(tableName);
            if (tableStartIndex < 0) {
                return sql;
            }
            int deleteStartIndex = tableStartIndex + underlineIndex;
            return new StringBuilder(sql).delete(deleteStartIndex, deleteStartIndex + tableNameSuffix.length() + 1).toString();
        }
        return sql;
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

