/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;

public class ArmsDbClientMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<ArmsDbClientMetricsState> ARMS_DB_CLIENT_METRICS_CONTEXT_KEY = ContextKey.named("arms-db-client-metrics-state");

    public ArmsDbClientMetrics(Meter meter) {
        super(meter);
    }

    public static OperationMetrics get() {
        return ArmsDbClientMetrics::new;
    }

    public static Long getDbSpanStartMills(Context context) {
        ArmsDbClientMetricsState state = context.get(ARMS_DB_CLIENT_METRICS_CONTEXT_KEY);
        if (state == null) {
            return null;
        }
        return state.getStartTimeMills();
    }

    public static Context attachStartState(Context context, Long startNanos) {
        return context.with(ARMS_DB_CLIENT_METRICS_CONTEXT_KEY, new ArmsDbClientMetricsState(null, startNanos));
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_DB_CLIENT_METRICS_CONTEXT_KEY, new ArmsDbClientMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        if (endAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS) == null) {
            return;
        }
        ArmsDbClientMetricsState state = context.get(ARMS_DB_CLIENT_METRICS_CONTEXT_KEY);
        if (state == null) {
            return;
        }
        this.totalRequestCount.add(1L, endAttributes, context);
        double duration = (double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS;
        this.requestDuration.add((long)duration, endAttributes, context);
        if (ArmsAttributesConvertUtil.hasError(context, endAttributes)) {
            this.errorRequestCount.add(1L, endAttributes);
            Span.fromContext(context).setStatus(StatusCode.ERROR);
        }
        if (ArmsAttributesConvertUtil.isSlowSql(duration)) {
            this.slowRequestCount.add(1L, endAttributes);
        }
        String callType = endAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY);
        String callKind = endAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY);
        Long rpcType = endAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS);
        if (StringUtils.isEmpty(callKind) || StringUtils.isEmpty(callType) || rpcType == null) {
            return;
        }
        this.recordOutCallQuantileMetrics(callKind, callType, rpcType, endAttributes, (long)duration);
    }

    @Override
    public void recordMetrics(Context context, Attributes recordAttributes, Attributes metricsAttributes) {
        if (recordAttributes.get(ArmsConstants.AttributeKeys.REQUEST_SIZE_KEY) != null) {
            this.requestSize.record(recordAttributes.get(ArmsConstants.AttributeKeys.REQUEST_SIZE_KEY), metricsAttributes);
        }
        if (recordAttributes.get(ArmsConstants.AttributeKeys.RESPONSE_SIZE_KEY) != null) {
            this.responseSize.record(recordAttributes.get(ArmsConstants.AttributeKeys.RESPONSE_SIZE_KEY), metricsAttributes);
        }
    }

    static class ArmsDbClientMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;
        private final long startTimeMills;

        public ArmsDbClientMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
            this.startTimeMills = System.currentTimeMillis();
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }

        public long getStartTimeMills() {
            return this.startTimeMills;
        }
    }
}

