/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.sample.SpanSampleFlagUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;

public class LocalRootSpanUpdater {
    public static void updateSpanName(Span span, String newSpanName) {
        if (span == null) {
            return;
        }
        span.updateName(newSpanName);
        LocalRootSpanUpdater.updateSpanSampleFlag(newSpanName, span);
        HotSpotRecorder.setProfilingInfo(span, false);
    }

    public static void updateSpanSampleFlag(String name, Span span) {
        Boolean sampleLater;
        Boolean skipByHttpMethod = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_HTTP_METHOD_KEY.getKey(), Context.current());
        if (ArmsRpcConfigState.rpcConfigState.shouldIgnore(name) || skipByHttpMethod != null && skipByHttpMethod.booleanValue()) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getDefault());
            AliyunContextHolderUtils.putToAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), true, Context.current());
            return;
        }
        Boolean skipMetric = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), Context.current());
        if (skipMetric != null && skipMetric.booleanValue()) {
            AliyunContextHolderUtils.putToAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), false, Context.current());
        }
        if ((sampleLater = SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLER_LATER_KEY, span)) != null && sampleLater.booleanValue()) {
            GlobalInstanceHolder.getInstance(SpanSampleFlagUpdater.class).updateSpanSampleFlag(name, span);
        }
    }
}

