/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.CustomExtractRecord;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.ExtractRule;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums.ExtractSourceEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums.ExtractTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.AbstractCustomParamExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.HttpServerCustomParamExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class HttpServerCustomParamExtractor<REQUEST, RESPONSE>
extends AbstractCustomParamExtractor<REQUEST, RESPONSE> {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerCustomParamExtractor.class.getName());
    private final SpanReader spanReader;
    HttpServerAttributesGetter<REQUEST, RESPONSE> getter;

    HttpServerCustomParamExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        if (this.spanReader == null) {
            logger.log(Level.SEVERE, "SpanReader is null, please check the configuration");
        }
    }

    public static <REQUEST, RESPONSE> HttpServerCustomParamExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpServerCustomParamExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    public static <REQUEST, RESPONSE> HttpServerCustomParamExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpServerCustomParamExtractor.builder(getter).build();
    }

    @Override
    public void onStart(Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Span span = LocalRootSpan.fromContextOrNull(context);
        if (span == null || this.spanReader == null || this.getCustomExtractService() == null) {
            return;
        }
        String rpcName = this.spanReader.readSpanName(span);
        Map<String, CustomExtractRecord> requestRecords = this.getCustomExtractService().getMatchedExtractRecord(rpcName, ExtractTypeEnum.HTTP_REQUEST_SERVER);
        this.doExtractForHttpServer(context, request, response, requestRecords, ExtractTypeEnum.HTTP_REQUEST_SERVER);
        if (response == null) {
            logger.log(Level.INFO, "Unable to extract parameters from empty response");
        } else {
            Map<String, CustomExtractRecord> responseRecords = this.getCustomExtractService().getMatchedExtractRecord(rpcName, ExtractTypeEnum.HTTP_RESPONSE_SERVER);
            this.doExtractForHttpServer(context, request, response, responseRecords, ExtractTypeEnum.HTTP_RESPONSE_SERVER);
        }
    }

    private void doExtractForHttpServer(Context context, REQUEST request, @Nullable RESPONSE response, Map<String, CustomExtractRecord> recordMap, ExtractTypeEnum type) {
        for (Map.Entry<String, CustomExtractRecord> entry : recordMap.entrySet()) {
            String attributeKey = entry.getKey();
            CustomExtractRecord record = entry.getValue();
            List<ExtractRule> orderedExtractRules = record.getOrderedExtractRules();
            String attributeValue = null;
            for (ExtractRule rule : orderedExtractRules) {
                Object carrier = this.adaptedGetParamCarrier(context, request, response, rule, type, record.getRecordId());
                if (carrier == null) {
                    logger.log(Level.INFO, "[" + record.getRecordId() + "]Carrier key is null, cannot get carrier from " + rule.getSource().name());
                    continue;
                }
                attributeValue = rule.doExtract(carrier);
                if (attributeValue == null || attributeValue.isEmpty()) continue;
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "HIT", record.getExtractType().name(), rule.getSource().name(), 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Get attribute of key [" + attributeKey + "] by rule [" + rule.getSource().name() + "]");
                break;
            }
            if (attributeValue == null || attributeValue.isEmpty()) {
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "MISS", record.getExtractType().name(), null, 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Cannot get attribute of key [" + attributeKey + "]");
                continue;
            }
            this.getCustomExtractService().cacheIncomeAttributes(context, record, attributeKey, attributeValue);
        }
    }

    private Object adaptedGetParamCarrier(Context context, REQUEST request, @Nullable RESPONSE response, ExtractRule rule, ExtractTypeEnum type, String recordId) {
        ExtractSourceEnum source = rule.getSource();
        if (!source.isSupported(type)) {
            logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
            return null;
        }
        String carrierKey = rule.getCarrierKey();
        if (ExtractSourceEnum.PARAMETER.equals((Object)source)) {
            Map<String, String[]> params = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            params = this.getter.getHttpRequestParams(request, Collections.singletonList(carrierKey));
            if (params == null || params.isEmpty()) {
                return null;
            }
            Object[] values = params.getOrDefault(carrierKey, null);
            if (values == null || values.length == 0) {
                return null;
            }
            if (values.length == 1) {
                return values[0];
            }
            return StringUtils.arrayToString(values);
        }
        if (ExtractSourceEnum.COOKIE.equals((Object)source)) {
            Map<String, String> cookies = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            if (ExtractTypeEnum.HTTP_REQUEST_SERVER.equals((Object)type)) {
                cookies = this.getter.getHttpRequestCookies(request, Collections.singleton(carrierKey));
            } else if (ExtractTypeEnum.HTTP_RESPONSE_SERVER.equals((Object)type)) {
                cookies = this.getter.getHttpResponseCookies(request, response, Collections.singleton(carrierKey));
            }
            if (cookies == null || cookies.isEmpty()) {
                return null;
            }
            String value = cookies.get(carrierKey);
            return value.isEmpty() ? null : value;
        }
        if (ExtractSourceEnum.HEADER.equals((Object)source)) {
            List<String> headers = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            if (ExtractTypeEnum.HTTP_REQUEST_SERVER.equals((Object)type)) {
                headers = this.getter.getHttpRequestHeader(request, carrierKey);
            } else if (ExtractTypeEnum.HTTP_RESPONSE_SERVER.equals((Object)type)) {
                headers = this.getter.getHttpResponseHeader(request, response, carrierKey);
            }
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            if (headers.size() == 1) {
                return headers.get(0);
            }
            return StringUtils.listToString(headers);
        }
        if (ExtractSourceEnum.BODY.equals((Object)source)) {
            return this.getCustomExtractService().getIncomeCarrier(context, type, rule.getSource());
        }
        logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
        return null;
    }
}

