/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.CustomExtractRecord;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.ExtractRule;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums.ExtractSourceEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums.ExtractTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.AbstractCustomParamExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class ExceptionCustomParamExtractor
extends AbstractCustomParamExtractor<Object, Object> {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(ExceptionCustomParamExtractor.class.getName());
    private static final ExceptionCustomParamExtractor INSTANCE = new ExceptionCustomParamExtractor();

    public static ExceptionCustomParamExtractor getInstance() {
        return INSTANCE;
    }

    private ExceptionCustomParamExtractor() {
    }

    @Override
    public void onStart(Context parentContext, Object request) {
    }

    @Override
    public void onEnd(Context context, Object request, @Nullable Object response, @Nullable Throwable error) {
        if (error == null || this.getCustomExtractService() == null) {
            return;
        }
        Span span = Span.fromContext(context);
        if (span == null) {
            return;
        }
        String spanId = span.getSpanContext().getSpanId();
        String className = error.getClass().getName();
        Map<String, CustomExtractRecord> exceptionRecords = this.getCustomExtractService().getMatchedExtractRecord(className, ExtractTypeEnum.EXCEPTION);
        for (Map.Entry<String, CustomExtractRecord> entry : exceptionRecords.entrySet()) {
            String attributeKey = entry.getKey();
            CustomExtractRecord record = entry.getValue();
            List<ExtractRule> extractRules = record.getOrderedExtractRules();
            String attributeValue = null;
            String carrier = null;
            for (ExtractRule rule : extractRules) {
                if (!rule.getSource().isSupported(ExtractTypeEnum.EXCEPTION)) {
                    LOGGER.log(Level.INFO, "[" + record.getRecordId() + "] Unsupported source " + rule.getSource().name() + " of type " + ExtractTypeEnum.EXCEPTION.name());
                    continue;
                }
                if (ExtractSourceEnum.MESSAGE.equals((Object)rule.getSource())) {
                    carrier = error.getMessage();
                }
                if (carrier != null) {
                    attributeValue = rule.doExtract(carrier);
                }
                if (attributeValue == null || attributeValue.isEmpty()) continue;
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "HIT", record.getExtractType().name(), rule.getSource().name(), 1);
                break;
            }
            if (attributeValue == null || attributeValue.isEmpty()) {
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "MISS", record.getExtractType().name(), null, 1);
                LOGGER.log(Level.INFO, "[" + record.getRecordId() + "] Cannot get attribute of key [" + attributeKey + "]");
                continue;
            }
            this.getCustomExtractService().cacheNormalAttributes(context, spanId, record, attributeKey, attributeValue);
        }
    }
}

