/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.PathMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AntPathMatcher;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import java.util.HashSet;
import java.util.Set;

public enum SpanInterfaceMatcher {
    INSTANCE;

    private final PathMatcher matcher = new AntPathMatcher();
    private volatile Set<String> customEqualsUrlSet = new HashSet<String>();
    private volatile Set<String> customEndWithUrlSet = new HashSet<String>();
    private volatile Set<String> customMatchUrlSet = new HashSet<String>();
    private boolean needMatch = false;

    public void reset() {
        this.needMatch = false;
        this.customEqualsUrlSet = new HashSet<String>();
        this.customEndWithUrlSet = new HashSet<String>();
        this.customMatchUrlSet = new HashSet<String>();
    }

    public void addCustomEqualsUrls(String filterPath) {
        this.initMatch();
        this.customEqualsUrlSet.add(filterPath);
    }

    public void addCustomEndWithUrls(String filterPath) {
        this.initMatch();
        this.customEndWithUrlSet.add(filterPath);
    }

    public void addCustomMatchUrls(String filterPath) {
        this.initMatch();
        this.customMatchUrlSet.add(filterPath);
    }

    public boolean shouldIgnoreSpanInterface(String newSpanName) {
        if (!this.needMatch) {
            return false;
        }
        if (StringUtils.isNullOrEmpty(newSpanName)) {
            return false;
        }
        boolean shouldIgnore = this.customEqualsUrlSet.contains(newSpanName);
        if (shouldIgnore) {
            return true;
        }
        if (!newSpanName.equals("/*")) {
            for (String suffix : this.customEndWithUrlSet) {
                if (!newSpanName.endsWith(suffix)) continue;
                return true;
            }
            for (String pattern : this.customMatchUrlSet) {
                if (!this.matcher.match(pattern, newSpanName)) continue;
                return true;
            }
        }
        return false;
    }

    private void initMatch() {
        if (!this.needMatch) {
            this.needMatch = true;
        }
    }

    public boolean isNeedMatch() {
        return this.needMatch;
    }
}

