/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsDataDegradationState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.TimeUnit;

public class ArmsCommonServiceMetrics
implements MetricsRecorder {
    private static final long NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    protected final LongCounter totalRequestCount;
    protected final LongCounter errorRequestCount;
    protected final LongCounter slowRequestCount;
    protected final LongCounter statusRequestCount;
    protected final LongCounter requestDuration;
    protected final DoubleHistogram requestQuantileDuration;
    protected final LongHistogram responseSize;
    protected final LongHistogram requestSize;
    protected final DoubleHistogram delayDuration;

    public ArmsCommonServiceMetrics(Meter meter) {
        this.totalRequestCount = meter.counterBuilder("arms_rpc_requests_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.errorRequestCount = meter.counterBuilder("arms_rpc_requests_error_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.slowRequestCount = meter.counterBuilder("arms_rpc_requests_slow_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.statusRequestCount = meter.counterBuilder("arms_rpc_requests_by_status_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.requestDuration = meter.counterBuilder("arms_rpc_requests_seconds").setUnit("{ms}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.requestQuantileDuration = meter.histogramBuilder("arms_rpc_requests_latency_seconds").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.responseSize = meter.histogramBuilder("arms_rpc_result_bytes").setUnit("By").setDescription("Arms response bytes").ofLongs().build();
        this.requestSize = meter.histogramBuilder("arms_rpc_request_bytes").setUnit("By").setDescription("Arms request bytes").ofLongs().build();
        this.delayDuration = meter.histogramBuilder("arms_rpc_delay_seconds").setUnit("s").setDescription("The latency of rpc invocation").build();
    }

    protected void onEnd0(Context context, long startNanos, long endNanos, Attributes allAttributes) {
        this.onEnd0(context, startNanos, endNanos, allAttributes, 1L);
    }

    protected void onEnd0(Context context, long startNanos, long endNanos, Attributes allAttributes, long count) {
        String callKind;
        this.totalRequestCount.add(count, allAttributes, context);
        long duration = (endNanos - startNanos) / NANOS_PER_MS;
        this.requestDuration.add(duration, allAttributes, context);
        if (ArmsAttributesConvertUtil.hasError(context, allAttributes)) {
            this.errorRequestCount.add(count, allAttributes);
            Span.fromContext(context).setStatus(StatusCode.ERROR);
        }
        if (ArmsAttributesConvertUtil.isSlowInterface(duration)) {
            this.slowRequestCount.add(count, allAttributes);
        }
        if (StringUtils.isEmpty(callKind = allAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY))) {
            return;
        }
        this.recordQuantileMetrics(callKind, allAttributes, duration);
    }

    protected void recordQuantileMetrics(String callKind, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable()) {
            return;
        }
        String callType = allAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY);
        Long rpcType = allAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS);
        if (StringUtils.isEmpty(callType) || rpcType == null) {
            return;
        }
        if (callKind.equalsIgnoreCase(UniCallKind.HTTP.getName()) || callKind.equalsIgnoreCase(UniCallKind.RPC.getName()) || callKind.equalsIgnoreCase(UniCallKind.CONSUMER.getName()) || callKind.equalsIgnoreCase(UniCallKind.SCHEDULE.getName()) || callKind.equalsIgnoreCase(UniCallKind.SERVER.getName()) || callKind.equalsIgnoreCase(UniCallKind.CUSTOM_ENTRY.getName())) {
            this.recordInCallQuantileMetrics(callKind, callType, rpcType, allAttributes, duration);
        } else {
            this.recordOutCallQuantileMetrics(callKind, callType, rpcType, allAttributes, duration);
        }
    }

    protected void recordInCallQuantileMetrics(String callKind, String callType, Long rpcType, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable() || !ArmsDataDegradationState.INSTANCE.isEnableQuantile4Interface()) {
            return;
        }
        String rpc = allAttributes.get(ArmsConstants.AttributeKeys.RPC);
        if (StringUtils.isEmpty(rpc)) {
            return;
        }
        Attributes quantileAttributes = Attributes.builder().put(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY, callType).put(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY, callKind).put(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, rpcType).put(ArmsConstants.AttributeKeys.RPC, rpc).build();
        this.requestQuantileDuration.record(duration, quantileAttributes);
    }

    protected void recordOutCallQuantileMetrics(String callKind, String callType, Long rpcType, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.SQL.getName()) || callKind.equalsIgnoreCase(UniCallKind.DB.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4DB()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.NO_SQL.getName()) || callKind.equalsIgnoreCase(UniCallKind.CACHE.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4NOSQL()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.HTTP_CLIENT.getName()) || callKind.equalsIgnoreCase(UniCallKind.RPC_CLIENT.getName()) || callKind.equalsIgnoreCase(UniCallKind.CLIENT.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4Outcall()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.CONSUMER.getName()) || callKind.equalsIgnoreCase(UniCallKind.PRODUCER.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4MQ()) {
            return;
        }
        String endpoint = allAttributes.get(ArmsConstants.AttributeKeys.ENDPOINT_KEY);
        String distId = allAttributes.get(ArmsConstants.AttributeKeys.DEST_ID_KEY);
        if (StringUtils.isEmpty(endpoint) || StringUtils.isEmpty(distId)) {
            return;
        }
        Attributes quantileAttributes = Attributes.builder().put(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY, callType).put(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY, callKind).put(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, rpcType).put(ArmsConstants.AttributeKeys.ENDPOINT_KEY, endpoint).put(ArmsConstants.AttributeKeys.DEST_ID_KEY, distId).build();
        this.requestQuantileDuration.record(duration, quantileAttributes);
    }
}

