/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.dto.ArmsPair;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsServiceTypeFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsSqlConfigState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.HashMap;
import java.util.Map;

public class ArmsAttributesConvertUtil {
    private static SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
    public static final Map<String, ArmsPair<ArmsRpcTypeEnum, ArmsServiceTypeFactory.ArmsServiceType>> supportDBSystem = new HashMap<String, ArmsPair<ArmsRpcTypeEnum, ArmsServiceTypeFactory.ArmsServiceType>>();

    private ArmsAttributesConvertUtil() {
    }

    public static String convertHttpStatus(int statusCode) {
        if (ArmsRpcConfigState.rpcConfigState.getRecordOriginalHttpCodeInMetrics().booleanValue()) {
            return statusCode + "";
        }
        if (statusCode == 200) {
            return "200";
        }
        if (statusCode > 200 && statusCode < 300) {
            return "2xx";
        }
        if (statusCode >= 300 && statusCode < 400) {
            return "3xx";
        }
        if (statusCode >= 400 && statusCode < 500) {
            return "4xx";
        }
        if (statusCode >= 100 && statusCode < 200) {
            return "1xx";
        }
        return "5xx";
    }

    public static boolean hasError(Context context, Attributes attributes) {
        Boolean isSpanError = null;
        Long statusCode = null;
        if (spanReader != null) {
            Span span = Span.fromContext(context);
            isSpanError = spanReader.readSpanStatus(span) == StatusCode.ERROR;
            statusCode = spanReader.getAttribute(span, SemanticAttributes.HTTP_STATUS_CODE);
        }
        if (statusCode != null && ArmsRpcConfigState.rpcConfigState.getSkipHttpErrorStatusSet().contains(statusCode.intValue())) {
            return false;
        }
        if (isSpanError != null && isSpanError.booleanValue()) {
            return true;
        }
        if (statusCode != null && (statusCode >= 400L || statusCode < 100L)) {
            return true;
        }
        String status = attributes.get(AttributeKey.stringKey("status"));
        return !StringUtils.isNullOrEmpty(status) && (status.startsWith("5") || status.startsWith("4"));
    }

    public static boolean isSlowInterface(double duration) {
        return duration > (double)ArmsRpcConfigState.rpcConfigState.getInterfaceThreshold();
    }

    public static boolean isSlowSql(double duration) {
        return duration > (double)ArmsSqlConfigState.configState.getSqlThreshold();
    }

    static {
        supportDBSystem.put("mysql", ArmsPair.pair(ArmsRpcTypeEnum.MYSQL, ArmsServiceTypeFactory.MYSQL));
        supportDBSystem.put("oracle", ArmsPair.pair(ArmsRpcTypeEnum.ORACLE, ArmsServiceTypeFactory.ORACLE));
        supportDBSystem.put("postgresql", ArmsPair.pair(ArmsRpcTypeEnum.POSTGRESQL, ArmsServiceTypeFactory.POSTGRESQL));
        supportDBSystem.put("mssql", ArmsPair.pair(ArmsRpcTypeEnum.SQLSERVER, ArmsServiceTypeFactory.SQLSERVER));
        supportDBSystem.put("mariadb", ArmsPair.pair(ArmsRpcTypeEnum.MARIADB, ArmsServiceTypeFactory.MARIADB));
        supportDBSystem.put("polardb", ArmsPair.pair(ArmsRpcTypeEnum.PPAS, ArmsServiceTypeFactory.PPAS));
        supportDBSystem.put("polardb2", ArmsPair.pair(ArmsRpcTypeEnum.PPAS, ArmsServiceTypeFactory.PPAS));
        supportDBSystem.put("ppas", ArmsPair.pair(ArmsRpcTypeEnum.PPAS, ArmsServiceTypeFactory.PPAS));
        supportDBSystem.put("oceanbase", ArmsPair.pair(ArmsRpcTypeEnum.OCEANBASE, ArmsServiceTypeFactory.OCEANBASE));
        supportDBSystem.put("clickhouse", ArmsPair.pair(ArmsRpcTypeEnum.CLICKHOUSE, ArmsServiceTypeFactory.CLICKHOUSE));
        supportDBSystem.put("cassandra", ArmsPair.pair(ArmsRpcTypeEnum.CASSANDRA, ArmsServiceTypeFactory.CASSANDRA));
        supportDBSystem.put("lindorm", ArmsPair.pair(ArmsRpcTypeEnum.LINDORM, ArmsServiceTypeFactory.LINDROM));
    }
}

