/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.InstrumenterEntranceTrigger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanCompressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.sample.LocalTailSampler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SampleInfoHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsProperties;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.SkywalkingContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.SkywalkingSpanBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.CustomExtractService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.CustomParamExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.flowcontrol.SimpleTokenBucket;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.resource.SimplifiedResourceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.tag.TagService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeAttributesBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.TraceSpanLimiter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsChildSpanAttribute;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsChildSpanContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsCustomSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsSpanCompressUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.InstrumenterAccess;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static volatile boolean flag = false;
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends CustomParamExtractor<? super REQUEST, ? super RESPONSE>> customParamExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends OperationListener> operationListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final boolean enabled;
    private final SpanSuppressor spanSuppressor;
    private final Attributes selfMonitorAttribute;
    private SpanCompressor spanCompressor;
    private final InstrumenterEntranceTrigger instrumenterEntranceTrigger;
    private final TagService tagService;
    private final ConvergeService convergeService;
    private SpanReader spanReader;
    private final LocalTailSampler tailSampler;
    private final CustomExtractService customExtractService;
    private static final PatchLogger logger = PatchLogger.getLogger(Instrumenter.class.getName());
    private UniCallKind uniCallKind;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.selfMonitorAttribute = Attributes.of(AttributeKey.stringKey("instrumentation_name"), this.instrumentationName);
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.operationListeners = builder.buildOperationListeners();
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.enabled = builder.enabled;
        this.spanSuppressor = builder.buildSpanSuppressor();
        this.spanCompressor = GlobalInstanceHolder.getInstance(SpanCompressor.class);
        this.instrumenterEntranceTrigger = GlobalInstanceHolder.getInstance(InstrumenterEntranceTrigger.class);
        this.tagService = GlobalInstanceHolder.getInstance(TagService.class);
        this.convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        this.tailSampler = GlobalInstanceHolder.getInstance(LocalTailSampler.class);
        this.customParamExtractors = new ArrayList(builder.customParamExtractors);
        this.customExtractService = GlobalInstanceHolder.getInstance(CustomExtractService.class);
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (this.instrumenterEntranceTrigger != null && !this.instrumenterEntranceTrigger.isInstrumenterEntranceEnable()) {
            return false;
        }
        if (!this.enabled || Instrumenter.shouldSkip()) {
            return false;
        }
        if (!SimpleTokenBucket.INSTANCE.canPass()) {
            SelfMonitorMetrics.increaseFlowControlLimit();
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressor.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    public Context start(Context parentContext, REQUEST request) {
        try {
            return this.doStart(parentContext, request, null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "[Instrumenter] start fail", e);
            return parentContext;
        }
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        try {
            this.doEnd(context, request, response, error, null);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "[Instrumenter] end fail", e);
        }
    }

    Context startAndEnd(Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, Instant startTime, Instant endTime) {
        Context context = this.doStart(parentContext, request, startTime);
        this.doEnd(context, request, response, error, endTime);
        return context;
    }

    /*
     * WARNING - void declaration
     */
    private Context doStart(Context parentContext, REQUEST request, @Nullable Instant startTime) {
        void var11_32;
        void var11_26;
        void var11_22;
        boolean spanCompressEnable;
        long startTimeToNanos;
        boolean selfMonitorSampled;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind);
        if (startTime != null) {
            spanBuilder.setStartTimestamp(startTime);
        }
        if (selfMonitorSampled = this.shouldSampleSelfMonitor(startTimeToNanos = Instrumenter.getStartNanos())) {
            SelfMonitorMetrics.increaseInstrumenterStartExecutedCount(this.selfMonitorAttribute);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        CompositeAttributesBuilder attributesBuilder = new CompositeAttributesBuilder();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributesBuilder, parentContext, request);
        }
        Context context3 = parentContext;
        context3 = context3.with(ArmsConstants.ContextKeys.ALL_EXCEPTION_IDS_KEY, new StringBuffer());
        context3 = AliyunContextHolderUtils.attachAliyunConyextHolderIfAbsent(context3);
        Attributes attributes = attributesBuilder.build();
        boolean localRoot = LocalRootSpan.isLocalRoot(context3);
        boolean bl = spanCompressEnable = this.spanCompressor != null && this.spanCompressor.isSpanCompressEnable();
        if (spanCompressEnable) {
            void var11_18;
            long startNanoTime = this.getStartNanoTimeFromRootSpan(context3);
            if (localRoot) {
                Context context4 = context3.with(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME, startNanoTime);
            }
            spanBuilder.setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
            List<ArmsCustomSpan> parentChildSpanList = parentContext.get(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY);
            if (parentChildSpanList != null) {
                void var11_16;
                Context context5 = var11_16.with(ArmsChildSpanContext.PARENT_CHILD_SPAN_CONTEXT_KEY, parentChildSpanList);
            }
            Context context7 = var11_18.with(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY, new ArrayList());
            context7 = context7.with(ArmsChildSpanContext.SPAN_START_NANO_TIME_CONTEXT_KEY, startNanoTime);
        }
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            Context context8 = contextCustomizer.onStart((Context)var11_22, request, attributes);
        }
        spanBuilder.setAllAttributes(attributes);
        Span span = spanBuilder.setParent((Context)var11_22).startSpan();
        Context context9 = this.handleSkywalkingContext((Context)var11_22, span);
        if (spanKind == SpanKind.INTERNAL) {
            SpanUtils.updateResource(span, SimplifiedResourceHolder.getSimplifiedResource());
            span.setAttribute(ArmsConstants.AttributeKeys.LOCAL_ROOT_SPAN_ID, LocalRootSpan.fromContext(context9).getSpanContext().getSpanId());
        }
        Context context10 = context9.with(span);
        Long rpcTypeIndex = attributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY);
        ArmsRpcTypeEnum armsRpcTypeEnum = ArmsRpcTypeEnum.getByIndex(rpcTypeIndex);
        if (this.uniCallKind == null) {
            this.uniCallKind = armsRpcTypeEnum.getUniCallKind();
        }
        if (!this.operationListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (OperationListener operationListener : this.operationListeners) {
                Context context11 = operationListener.onStart((Context)var11_26, Attributes.empty(), startNanos);
            }
        }
        if (localRoot) {
            Context context14 = LocalRootSpan.store((Context)var11_26, span);
            context14 = this.initSampleInfo(parentContext, context14);
            context14 = TraceSpanLimiter.INSTANCE.initIfAbsent(context14);
        } else {
            Context context15 = this.removeSampleInfoInNonLocalRootSpan((Context)var11_26);
        }
        if (this.customExtractService != null && this.customExtractService.isEnable()) {
            this.customExtractService.extractOnStart((Context)var11_32, request, this.customParamExtractors);
        }
        if (!spanCompressEnable && span.getSpanContext().isSampled() && TraceSpanLimiter.INSTANCE.exceedSpanLimit((Context)var11_32)) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getDefault());
        }
        if (selfMonitorSampled) {
            Long totalRT = System.nanoTime() - startTimeToNanos;
            SelfMonitorMetrics.increaseInstrumenterStartResponseTime(this.selfMonitorAttribute, totalRT);
        }
        return this.spanSuppressor.storeInContext((Context)var11_32, spanKind, span);
    }

    private Context initSampleInfo(Context parentContext, Context currentContext) {
        SampleInfoHolder sampleInfoHolder = new SampleInfoHolder();
        Span parentSpan = Span.fromContext(parentContext);
        if (!parentSpan.getSpanContext().isValid()) {
            sampleInfoHolder.setUpstreamSampled(null);
        } else {
            sampleInfoHolder.setUpstreamSampled(parentSpan.getSpanContext().isSampled());
        }
        return currentContext.with(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY, sampleInfoHolder);
    }

    private Context removeSampleInfoInNonLocalRootSpan(Context context) {
        return context.with(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY, SampleInfoHolder.INVALID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, @Nullable Instant endTime) {
        long endRTNano = Instrumenter.getNanos(endTime);
        boolean selfMonitorSampled = this.shouldSampleSelfMonitor(endRTNano);
        if (selfMonitorSampled) {
            SelfMonitorMetrics.increaseInstrumenterEndExecutedCount(this.selfMonitorAttribute);
        }
        Span span = Span.fromContext(context);
        if (error != null) {
            error = this.errorCauseExtractor.extract(error);
            span.recordException(error);
            span.setStatus(StatusCode.ERROR);
        }
        if (this.customExtractService != null && this.customExtractService.isEnable()) {
            this.customExtractService.extractOnEnd(context, request, response, error, this.customParamExtractors);
        }
        CompositeAttributesBuilder attributesBuilder = new CompositeAttributesBuilder();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributesBuilder, context, request, response, error);
        }
        AttributesBuilder[] attributesBuilders = attributesBuilder.buildAttributesBuilder(this.convergeService, this.uniCallKind);
        AttributesBuilder spanAttributesBuilder = attributesBuilders[0];
        AttributesBuilder metricsAttributesBuilder = attributesBuilders[1];
        if (this.customExtractService != null && this.customExtractService.isEnable()) {
            boolean isIncomeSpan = this.isIncomeSpan(span);
            this.customExtractService.injectSpanAttribute(spanAttributesBuilder, context, span.getSpanContext().getSpanId(), isIncomeSpan);
            this.customExtractService.resetSpanStatus(span, context, spanAttributesBuilder, metricsAttributesBuilder, isIncomeSpan);
            this.customExtractService.cleanupAllCache(span.getSpanContext().getSpanId(), context, isIncomeSpan);
        }
        Attributes spanAttributes = attributesBuilders[0].build();
        Attributes metricsAttributes = attributesBuilders[1].build();
        Attributes recordAttributes = attributesBuilders[2].build();
        span.setAllAttributes(spanAttributes);
        if (!this.operationListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            ListIterator<? extends OperationListener> i = this.operationListeners.listIterator(this.operationListeners.size());
            while (i.hasPrevious()) {
                this.doInvokeListenerOnEnd(i.previous(), context, metricsAttributes, recordAttributes, endNanos);
            }
        }
        SpanStatusBuilderImpl spanStatusBuilder = new SpanStatusBuilderImpl(span);
        this.spanStatusExtractor.extract(spanStatusBuilder, request, response, error);
        boolean spanCompressEnable = this.spanCompressor != null && this.spanCompressor.isSpanCompressEnable();
        int cachedSpanLimit = 500;
        if (this.spanCompressor != null) {
            cachedSpanLimit = this.spanCompressor.getCachedSpanLimit();
        }
        try {
            HotSpotRecorder.setWallClockAttribute(span);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to set profiling info ", t);
        }
        if (spanCompressEnable) {
            List<ArmsCustomSpan> parentChildSpanList = context.get(ArmsChildSpanContext.PARENT_CHILD_SPAN_CONTEXT_KEY);
            Long startTimeNanos = context.get(ArmsChildSpanContext.SPAN_START_NANO_TIME_CONTEXT_KEY);
            int rpcType = ArmsRpcTypeEnum.LOCAL_CALL.getCode();
            Long rpcTypeObject = metricsAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE);
            if (rpcTypeObject != null) {
                rpcType = rpcTypeObject.intValue();
            }
            if (startTimeNanos == null) {
                startTimeNanos = 0L;
            }
            ArmsCustomSpan armsCustomSpan = this.createArmsCustomSpan(this.spanNameExtractor.extract(request), spanAttributes.get(ArmsConstants.AttributeKeys.RPC), rpcType, startTimeNanos, span);
            List<ArmsCustomSpan> childSpanList = context.get(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY);
            if (childSpanList != null) {
                armsCustomSpan.setChildArmsCustomSpanList(childSpanList);
            }
            if (parentChildSpanList != null) {
                Boolean closed = false;
                if (this.spanReader != null) {
                    Span localRootSpan;
                    Span span2 = localRootSpan = LocalRootSpan.fromContext(context);
                    synchronized (span2) {
                        closed = this.spanReader.getAttribute(localRootSpan, ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_ATTR_KEY);
                        if (closed != null && closed.booleanValue()) {
                            this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                        }
                    }
                }
                if (closed == null || !closed.booleanValue()) {
                    List<ArmsCustomSpan> list = parentChildSpanList;
                    synchronized (list) {
                        if (armsCustomSpan.canEnd()) {
                            this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                        } else if (!ArmsSpanCompressUtil.mergeChildSpan(parentChildSpanList, armsCustomSpan)) {
                            if (parentChildSpanList.size() < cachedSpanLimit) {
                                parentChildSpanList.add(armsCustomSpan);
                            } else {
                                this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                            }
                        }
                    }
                }
            } else {
                Span localRootSpan;
                Span span3 = localRootSpan = LocalRootSpan.fromContext(context);
                synchronized (span3) {
                    localRootSpan.setAttribute(ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_ATTR_KEY, Boolean.valueOf(true));
                    localRootSpan.setAttribute(ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_TIME_ATTR_KEY, Long.valueOf(System.nanoTime()));
                }
                this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
            }
        } else if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
        if (selfMonitorSampled) {
            Long endTotalRT = System.nanoTime() - endRTNano;
            SelfMonitorMetrics.increaseInstrumenterEndResponseTime(this.selfMonitorAttribute, endTotalRT);
            this.recordSampleInfo(context);
        }
    }

    private ArmsCustomSpan createArmsCustomSpan(String name, @Nullable String rpcName, int rpcType, Long startTimeNanos, Span span) {
        long duration;
        StatusCode statusCode = StatusCode.UNSET;
        if (this.spanReader != null) {
            duration = this.spanReader.getLatencyNanos(span);
            statusCode = this.spanReader.readSpanStatus(span);
        } else {
            duration = System.currentTimeMillis() - TimeUnit.NANOSECONDS.toMillis(startTimeNanos);
        }
        return ArmsCustomSpan.create(name, rpcName, rpcType, duration, startTimeNanos, statusCode, span);
    }

    private UnsafeAttributes getSpanAttributes(UnsafeAttributes attributes) {
        UnsafeAttributes spanAttributes = new UnsafeAttributes();
        attributes.forEach((BiConsumer<? super AttributeKey<?>, ? super Object>)((BiConsumer<AttributeKey, Object>)(attributeKey, o) -> {
            if (!ArmsProperties.armsSpanDiscardAttributesKeySet.contains(attributeKey.getKey())) {
                spanAttributes.put(attributeKey, o);
                if (attributeKey.getKey().equalsIgnoreCase("destId")) {
                    spanAttributes.put(ArmsConstants.AttributeKeys.OUT_ID_KEY, o);
                }
            }
        }));
        return spanAttributes;
    }

    private void endArmsRootSpan(Context context, ArmsCustomSpan armsCustomSpan, BooleanSupplier exceedSpanThreshold) {
        boolean sampleByTailSampling = false;
        if (!armsCustomSpan.getSpan().getSpanContext().isSampled() && ArmsRpcTypeEnum.isIncomeRpcType(armsCustomSpan.getRpcType()) && this.tailSampler != null) {
            sampleByTailSampling = this.tailSampler.shouldSample(context, armsCustomSpan.getSpan(), armsCustomSpan.getRpcName(), armsCustomSpan.getDuration());
        }
        ArmsSpanCompressUtil.endRootSpan(armsCustomSpan, sampleByTailSampling, exceedSpanThreshold);
    }

    private Context handleSkywalkingContext(Context context, Span span) {
        SkywalkingContext parentSkywalkingContext = context.get(SkywalkingContext.SKYWALKING_CONTEXT_KEY);
        if (parentSkywalkingContext != null) {
            if (span.getSpanContext().getTraceFlags().isSampled()) {
                parentSkywalkingContext.setSample("1");
            }
            SkywalkingSpanBuilder skywalkingSpanBuilder = new SkywalkingSpanBuilder(parentSkywalkingContext);
            SkywalkingContext skywalkingSpanContext = skywalkingSpanBuilder.startSpan();
            span.setAttribute("swTraceId", skywalkingSpanContext.getTraceId());
            span.setAttribute("swSpanId", (long)skywalkingSpanContext.getSpanId().intValue());
            span.setAttribute("swSegmentId", skywalkingSpanContext.getSegmentId());
            if (parentSkywalkingContext.getTraceId() != null) {
                span.setAttribute("swParentSpanId", (long)parentSkywalkingContext.getSpanId().intValue());
                span.setAttribute("swParentSegmentId", parentSkywalkingContext.getSegmentId());
            }
            return context.with(SkywalkingContext.SKYWALKING_CONTEXT_KEY, skywalkingSpanContext);
        }
        return context;
    }

    private void recordSampleInfo(Context context) {
        SampleInfoHolder holder = context.get(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY);
        if (holder != null && holder.isValid()) {
            Span span = Span.fromContext(context);
            if (holder.getUpstreamSampled() == null) {
                holder.setLocalSampled(span.getSpanContext().isSampled());
                holder.setSampleFlag(SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLING_REASON_KEY, span));
            } else if (holder.getUpstreamSampled().booleanValue()) {
                holder.setLocalSampled(null);
            } else {
                holder.setLocalSampled(span.getSpanContext().isSampled());
                holder.setSampleFlag(SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLING_REASON_KEY, span));
            }
            SelfMonitorMetrics.increaseSampleCount(holder);
        }
    }

    private void doInvokeListenerOnEnd(OperationListener listener, Context context, Attributes attributes, Attributes recordAttributes, long endNanos) {
        if (listener instanceof MetricsRecorder) {
            Boolean skipByRpc = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), context);
            Boolean skipByMethod = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_HTTP_METHOD_KEY.getKey(), context);
            if (skipByRpc != null && skipByRpc.booleanValue() || skipByMethod != null && skipByMethod.booleanValue()) {
                return;
            }
            if (!recordAttributes.isEmpty()) {
                MetricsRecorder metricsRecorder = (MetricsRecorder)((Object)listener);
                metricsRecorder.recordMetrics(context, recordAttributes, attributes);
            }
        }
        listener.onEnd(context, attributes, endNanos);
    }

    private long getStartNanoTimeFromRootSpan(Context context) {
        if (context.get(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME) != null && this.spanReader != null) {
            Long rootClosedNanoTime;
            long nanoTime = context.get(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME);
            Span rootSpan = LocalRootSpan.fromContext(context);
            if (this.spanReader.hasEnded(rootSpan) && (rootClosedNanoTime = this.spanReader.getAttribute(rootSpan, ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_TIME_ATTR_KEY)) != null) {
                return nanoTime + this.spanReader.getLatencyNanos(rootSpan) + (System.nanoTime() - rootClosedNanoTime);
            }
            return nanoTime + this.spanReader.getLatencyNanos(rootSpan);
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    private boolean shouldSampleSelfMonitor(Long startTimeToNanos) {
        return startTimeToNanos % SelfMonitorMetrics.SELF_MONITOR_SAMPLE_RATE == 0L;
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }

    private static long getStartNanos() {
        return System.nanoTime();
    }

    private static long getStartMillisTime() {
        return System.currentTimeMillis();
    }

    public static boolean shouldSkip() {
        String groupName = Thread.currentThread().getThreadGroup().getName();
        return groupName.equals(ArmsThreadFactory.group.getName()) || groupName.equals("aliyun-mse-thread-group");
    }

    private boolean isIncomeSpan(Span span) {
        if (this.spanReader == null || span == null) {
            return false;
        }
        Long rpcType = this.spanReader.getAttribute(span, ArmsConstants.AttributeKeys.RPC_TYPE);
        return rpcType != null && ArmsRpcTypeEnum.isIncomeRpcType(rpcType.intValue());
    }

    public void setSpanCompressor(SpanCompressor spanCompressor) {
        this.spanCompressor = spanCompressor;
    }

    public void setSpanReader(SpanReader spanReader) {
        this.spanReader = spanReader;
    }

    static {
        InstrumenterUtil.setInstrumenterAccess(new InstrumenterAccess(){

            public <RQ, RS> Context startAndEnd(Instrumenter<RQ, RS> instrumenter, Context parentContext, RQ request, @Nullable RS response, @Nullable Throwable error, Instant startTime, Instant endTime) {
                return instrumenter.startAndEnd(parentContext, request, response, error, startTime, endTime);
            }
        });
    }
}

