/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.event;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.event.ArmsEventExporter;
import java.util.Map;

public class ArmsEvent {
    private final Map<String, String> labels;
    private final Map<String, String> annotations;
    private final Long startsAt;
    private final Long endsAt;
    public static final String ARMS_INVOLVEDOBJECT_KIND = "_aliyun_arms_involvedObject_kind";
    public static final String ARMS_INVOLVEDOBJECT_TYPE = "_aliyun_arms_involvedObject_type";
    public static final String ARMS_INVOLVEDOBJECT_ID = "_aliyun_arms_involvedObject_id";
    public static final String ARMS_INVOLVEDOBJECT_NAME = "_aliyun_arms_involvedObject_name";
    public static final String ARMS_INVOLVEDOBJECT_UID = "_aliyun_arms_involvedObject_uid";
    public static final String ARMS_INVOLVEDOBJECT_REGIONID = "_aliyun_arms_involvedObject_regionId";
    public static final String ARMS_INVOLVEDOBJECT_PROFILER = "_aliyun_arms_involvedObject_profiler";
    public static final String ARMS_INVOLVEDOBJECT_EVENTID = "_aliyun_arms_involvedObject_eventId";

    ArmsEvent(Map<String, String> labels, Map<String, String> annotations, Long startsAt, Long endsAt) {
        this.labels = labels;
        this.annotations = annotations;
        this.startsAt = startsAt;
        this.endsAt = endsAt;
        labels.put(ARMS_INVOLVEDOBJECT_KIND, "app");
        labels.put(ARMS_INVOLVEDOBJECT_TYPE, "trace");
        if (StringUtils.isNotEmpty(AgentInfo.INSTANCE.getAppId())) {
            labels.put(ARMS_INVOLVEDOBJECT_ID, AgentInfo.INSTANCE.getAppId());
        } else if (StringUtils.isNotEmpty(AgentInfo.INSTANCE.getMseAppId())) {
            labels.put(ARMS_INVOLVEDOBJECT_ID, AgentInfo.INSTANCE.getMseAppId());
        }
        if (StringUtils.isNotEmpty(AgentInfo.INSTANCE.getAppName())) {
            labels.put(ARMS_INVOLVEDOBJECT_NAME, AgentInfo.INSTANCE.getAppName());
        } else if (StringUtils.isNotEmpty(AgentInfo.INSTANCE.getMseAppName())) {
            labels.put(ARMS_INVOLVEDOBJECT_NAME, AgentInfo.INSTANCE.getMseAppName());
        }
        labels.put("serverIp", AgentInfo.INSTANCE.getIp());
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public void export() {
        ArmsEventExporter instance = GlobalInstanceHolder.getInstance(ArmsEventExporter.class);
        if (instance != null) {
            instance.exportEvent(this);
        }
    }
}

