/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogAgentStaticManager;

@Endpoint(value=ConfigEnum.MSE_APP_CONFIG_ENDPOINT)
@Namespace(value=ConfigEnum.MSE_APP_CONFIG_NAMESPACE)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
public class LogConfigState
extends State {
    public static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(LogConfigState.class.getName());

    public LogConfigState() {
        super.registerConfigInstance(this);
    }

    @DataId(value=ConfigEnum.EDAS_LOG4J2_CONFIG_DATA_ID)
    @Callback
    public void onLog4j2ConfigUpdated(String config) {
        this.onConfigUpdated0("log4j2", config);
    }

    @DataId(value=ConfigEnum.EDAS_LOGBACK_CONFIG_DATA_ID)
    @Callback
    public void onLogbackConfigUpdated(String config) {
        this.onConfigUpdated0("logback", config);
    }

    private void onConfigUpdated0(String framework, String config) {
        if (StringUtils.isEmpty(config)) {
            return;
        }
        try {
            LogAgentStaticManager.onReceiveConfigInfo(framework, config);
        }
        catch (Throwable e) {
            logger.error("[dynamic log config] error: " + e.getMessage(), e);
        }
    }
}

