/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig;

import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogAgentStaticManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LogConfig {
    public static final String UNKNOWN_ERROR_MESSAGE = "Edas.errorcode.OperationFailed.UnknownError.message";
    public static final String APP_LOG_CONFIG_NOT_FOUND_MESSAGE = "Edas.errorcode.app.log.config.not.found.message";
    public static final String APP_LOG_CONFIG_FROM_MESSAGE = "Edas.errorcode.app.log.config.from.message";
    public static final String APP_LOG_CONFIG_FROM_PART_MESSAGE = "Edas.errorcode.app.log.config.from.part.message";
    public static final String APP_LOG_CONFIG_VERIFY_SUCCESS_MESSAGE = "Edas.errorcode.app.log.config.verify.success.message";
    public String id;
    public String framework;
    public String name;
    public String desc;
    public long lastModifiedTime;
    public String content;
    public String md5;
    public String operator;
    public boolean valid;
    public String format;
    public List<ActionScope> actionScopes = new ArrayList<ActionScope>();

    public LogConfig() {
    }

    public LogConfig(String framework, String name, String desc, long lastModifiedTime, String content, String md5, String operator, boolean valid, List<ActionScope> actionScopes) {
        this.framework = framework;
        this.name = name;
        this.desc = desc;
        this.lastModifiedTime = lastModifiedTime;
        this.content = content;
        this.md5 = md5;
        this.operator = operator;
        this.valid = valid;
        this.actionScopes = actionScopes;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFramework() {
        return this.framework;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public List<ActionScope> getActionScopes() {
        return this.actionScopes;
    }

    public void setActionScopes(List<ActionScope> actionScopes) {
        this.actionScopes = actionScopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogConfig logConfig = (LogConfig)o;
        if (this.lastModifiedTime != logConfig.lastModifiedTime) {
            return false;
        }
        if (this.valid != logConfig.valid) {
            return false;
        }
        if (!Objects.equals(this.id, logConfig.id)) {
            return false;
        }
        if (!Objects.equals(this.framework, logConfig.framework)) {
            return false;
        }
        if (!Objects.equals(this.name, logConfig.name)) {
            return false;
        }
        if (!Objects.equals(this.desc, logConfig.desc)) {
            return false;
        }
        if (!Objects.equals(this.content, logConfig.content)) {
            return false;
        }
        if (!Objects.equals(this.md5, logConfig.md5)) {
            return false;
        }
        if (!Objects.equals(this.operator, logConfig.operator)) {
            return false;
        }
        if (!Objects.equals(this.format, logConfig.format)) {
            return false;
        }
        return Objects.equals(this.actionScopes, logConfig.actionScopes);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + (int)(this.lastModifiedTime ^ this.lastModifiedTime >>> 32);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.md5 != null ? this.md5.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.valid ? 1 : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.actionScopes != null ? this.actionScopes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LogConfig{id='" + this.id + '\'' + ", framework='" + this.framework + '\'' + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", lastModifiedTime=" + this.lastModifiedTime + ", content='" + this.content + '\'' + ", md5='" + this.md5 + '\'' + ", operator='" + this.operator + '\'' + ", valid=" + this.valid + ", format='" + this.format + '\'' + ", actionScopes=" + this.actionScopes + '}';
    }

    public boolean isUpdateThan(LogConfig old) {
        return this.lastModifiedTime > old.lastModifiedTime && !LogAgentStaticManager.equals(this.content, old.content);
    }

    public static class CommandResponse {
        public boolean success;
        public String message;
        public Object[] args;
        public Object data;
        public Throwable throwable;

        public static CommandResponse success(Object data) {
            return new CommandResponse(true, data, null, null, null);
        }

        public static CommandResponse success(Object data, String message, Object[] args) {
            return new CommandResponse(true, data, message, args, null);
        }

        public static CommandResponse fail(String message, Object[] args, Throwable throwable) {
            return new CommandResponse(false, null, message, args, throwable);
        }

        public static CommandResponse fail(String message, Object ... args) {
            return new CommandResponse(false, null, message, args, null);
        }

        public CommandResponse(boolean success, Object data, String message, Object[] args, Throwable throwable) {
            this.success = success;
            this.message = message;
            this.args = args;
            this.data = data;
            this.throwable = throwable;
        }

        public void setMessageAndArgs(String message, Object[] args) {
            this.message = message;
            this.args = args;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }
    }

    public static class ActionScope {
        public static final String APP = "app";
        public static final String GROUP = "group";
        public static final String ENV_TYPE = "envType";
        public static final String ENV_VAR = "envVar";
        public static final String SYSTEM_PROPERTY = "systemProperty";
        public static final String ECC_ID = "eccId";
        public String name;
        public String value;

        public ActionScope() {
        }

        public ActionScope(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "ActionScope{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

