/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.config;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.ArmsCommonUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MseConstants;

public enum ConfigEnum {
    ARMS_APP_CONFIG_ENDPOINT(ConfigPropertiesUtil.getString("profiler.acm.endpoint", "addr-cn-zhangjiakou-internal.edas.aliyun.com")),
    ARMS_APP_CONFIG_GROUP_ID(ConfigPropertiesUtil.getString("profiler.acm.region.id", "cn-zhangjiakou")),
    ARMS_APP_CONFIG_DATA_ID(ArmsCommonUtils.getArmsAppDataId(AgentInfo.INSTANCE.getAppId())),
    ARMS_APP_CUSTOM_CONFIG_DATA_ID(ArmsCommonUtils.getArmsCustomExtractDataId(AgentInfo.INSTANCE.getAppId())),
    ARMS_HEAP_DUMP_DATA_ID(ArmsCommonUtils.getArmsHeapDumpDataId(AgentInfo.INSTANCE.getAppId())),
    ARMS_GLOBAL_CONFIG_DATA_ID(ArmsCommonUtils.getArmsGlobalConfigDataId()),
    ARMS_APP_CONFIG_NAMESPACE(ConfigPropertiesUtil.getString("profiler.acm.tenant", "c845a7b4-23a1-4f28-a380-5ab30d8a280f")),
    MSE_APP_CONFIG_ENDPOINT(ConfigPropertiesUtil.getString("profiler.acm.endpoint", "acm.aliyun.com")),
    MSE_APP_CONFIG_NAMESPACE(ConfigPropertiesUtil.getString("profiler.acm.microservice.namespace", "2903e6c1-4d28-495a-ac5d-a007cfe53ebd")),
    MSE_APP_SENTINEL_CONFIG_GROUP(MseConstants.SENTINEL_GROUP_ID),
    MSE_APP_SENTINEL_DATASOURCE_ENABLE("micro.service.sentinel.datasource.enable"),
    MSE_APP_TRAFFIC_CONFIG_GROUP(MseConstants.regionId),
    MSE_APP_TRAFFIC_DATASOURCE_ENABLE("micro.service.traffic.datasource.enable"),
    MSE_APP_LOSSLESS_CONFIG_GROUP(MseConstants.regionId),
    MSE_APP_LOSSLESS_DATASOURCE_ENABLE("micro.service.lossless.datasource.enable"),
    EDAS_SCG_ROUTE_DATA_ID(String.format("micro.service.scg.routes.%s", ConfigEnum.convertToValidAppId(MseConstants.appId))),
    EDAS_SCG_DEFAULT_FILTERS_DATA_ID(String.format("micro.service.scg.defaultFilters.%s", ConfigEnum.convertToValidAppId(MseConstants.appId))),
    MSE_AUTH_DUBBO_CONFIG_DATA_ID(String.format("micro.service.auth.DUBBO.%s", ConfigEnum.convertToValidAppId(MseConstants.appId))),
    MSE_AUTH_SRPING_CLOUD_CONFIG_DATA_ID(String.format("micro.service.auth.SPRING_CLOUD.%s", ConfigEnum.convertToValidAppId(MseConstants.appId))),
    EDAS_LOGBACK_CONFIG_DATA_ID(String.format("dynamic.log.config.logback.%s", ConfigEnum.convertToValidAppId(MseConstants.appId))),
    EDAS_LOG4J2_CONFIG_DATA_ID(String.format("dynamic.log.config.log4j2.%s", ConfigEnum.convertToValidAppId(MseConstants.appId)));

    private String value;

    private ConfigEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static final String convertToValidAppId(String appId) {
        if (appId == null || appId.isEmpty()) {
            return appId;
        }
        return appId.replace('@', '-');
    }
}

