/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsJvmType;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsJvmVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsSystemPropertyKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.CollectionUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

public class JvmUtils {
    private static final ArmsJvmVersion JVM_VERSION = JvmUtils.getVersion0();
    private static final ArmsJvmType JVM_TYPE = JvmUtils.getType0();

    private JvmUtils() {
    }

    public static ArmsJvmVersion getVersion() {
        return JVM_VERSION;
    }

    public static ArmsJvmType getType() {
        return JVM_TYPE;
    }

    public static boolean supportsVersion(ArmsJvmVersion other) {
        return JVM_VERSION.onOrAfter(other);
    }

    public static String getSystemProperty(ArmsSystemPropertyKey systemPropertyKey) {
        return System.getProperty(systemPropertyKey.getKey(), "");
    }

    public static String getJvmGarbageCollectors() {
        String garbageCollectors = "";
        try {
            List<GarbageCollectorMXBean> garbageCollectorMXBeanList = ManagementFactory.getGarbageCollectorMXBeans();
            if (CollectionUtils.isNotEmpty(garbageCollectorMXBeanList)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (GarbageCollectorMXBean mxBean : garbageCollectorMXBeanList) {
                    if (StringUtils.isEmpty(mxBean.getName())) continue;
                    stringBuilder.append(mxBean.getName().replace(" ", "_"));
                    stringBuilder.append(",");
                }
                garbageCollectors = stringBuilder.substring(0, stringBuilder.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return garbageCollectors;
    }

    private static ArmsJvmVersion getVersion0() {
        String javaVersion = JvmUtils.getSystemProperty(ArmsSystemPropertyKey.JAVA_SPECIFICATION_VERSION);
        return ArmsJvmVersion.getFromVersion(javaVersion);
    }

    private static ArmsJvmType getType0() {
        String javaVmName = JvmUtils.getSystemProperty(ArmsSystemPropertyKey.JAVA_VM_NAME);
        return ArmsJvmType.fromVmName(javaVmName);
    }
}

