/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.HostAndPort;

public class EndPointUtils {
    public static String getEndPoint(String requestUrl, String defaultValue) {
        if (requestUrl == null) {
            return defaultValue;
        }
        String urlString = requestUrl.trim();
        if (urlString.isEmpty()) {
            return defaultValue;
        }
        String hostAndPort = EndPointUtils.parseHostAndPort(urlString);
        if (hostAndPort == null) {
            return requestUrl;
        }
        int portPosition = hostAndPort.indexOf(58);
        if (portPosition != -1) {
            int port = -1;
            try {
                port = Integer.parseInt(hostAndPort.substring(portPosition + 1));
            }
            catch (NumberFormatException nfe) {
                return hostAndPort;
            }
            String host = hostAndPort.substring(0, portPosition);
            return HostAndPort.toHostAndPortString(host, port);
        }
        return hostAndPort;
    }

    private static String parseHostAndPort(String requestUrl) {
        int length = requestUrl.length();
        int startPosition = 0;
        int protocolPosition = requestUrl.indexOf("://");
        if (protocolPosition == -1) {
            return null;
        }
        startPosition = protocolPosition + 3;
        int endPoisition = length;
        for (int i = startPosition; i < length; ++i) {
            char c = requestUrl.charAt(i);
            if (c != '/' && c != '?') continue;
            endPoisition = i;
            break;
        }
        return requestUrl.substring(startPosition, endPoisition);
    }
}

