/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import java.util.zip.Checksum;

public class CRC64
implements Checksum {
    private static final long POLY = -3932672073523589310L;
    private static final long[] table = new long[256];
    private long value = 0L;

    public byte[] getBytes() {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(this.value >>> i * 8);
        }
        return b;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void update(byte[] b, int len) {
        int idx = 0;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        while (len > 0) {
            this.value = table[(int)(this.value ^ (long)b[idx]) & 0xFF] ^ this.value >>> 8;
            ++idx;
            --len;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    public void update(byte b) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        this.value = table[(int)(this.value ^ (long)b) & 0xFF] ^ this.value >>> 8;
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void update(int b) {
        this.update((byte)(b & 0xFF));
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i = off;
        while (len > 0) {
            this.update(b[i++]);
            --len;
        }
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            long crc = n;
            for (int k = 0; k < 8; ++k) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64.table[n] = crc;
        }
    }
}

