/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ArmsRuntimeMXBeanUtils {
    private static final RuntimeMXBean RUNTIME_MBEAN = ManagementFactory.getRuntimeMXBean();
    private static long START_TIME = 0L;
    private static int PID = 0;
    private static final Random RANDOM = new Random();

    private ArmsRuntimeMXBeanUtils() {
    }

    public static int getPid() {
        if (PID == 0) {
            PID = ArmsRuntimeMXBeanUtils.getPid0();
        }
        return PID;
    }

    public static List<String> getVmArgs() {
        List<String> vmArgs = RUNTIME_MBEAN.getInputArguments();
        StringBuffer sb = new StringBuffer();
        sb.append("VmArgs:");
        if (vmArgs == null) {
            return Collections.emptyList();
        }
        for (String one : vmArgs) {
            sb.append(one).append(",");
        }
        return vmArgs;
    }

    private static int getPid0() {
        String name = RUNTIME_MBEAN.getName();
        int pidIndex = name.indexOf(64);
        if (pidIndex == -1) {
            return ArmsRuntimeMXBeanUtils.getNegativeRandomValue();
        }
        String strPid = name.substring(0, pidIndex);
        try {
            return Integer.parseInt(strPid);
        }
        catch (NumberFormatException e) {
            return ArmsRuntimeMXBeanUtils.getNegativeRandomValue();
        }
    }

    private static int getNegativeRandomValue() {
        int abs = Math.abs(RANDOM.nextInt());
        if (abs == Integer.MIN_VALUE) {
            return -1;
        }
        return abs;
    }

    public static String getName() {
        return RUNTIME_MBEAN.getName();
    }
}

