/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class ArmsNetworkUtils {
    public static final String ERROR_HOST_NAME = "UNKNOWN-HOST";
    private static final String LOOPBACK_ADDRESS_V4_1 = "127.0.0.1";
    private static final String LOOPBACK_ADDRESS_V4_2 = "127.0.1.1";
    private static final String LOOPBACK_ADDRESS_V6 = "0:0:0:0:0:0:0:1";
    public static final String LOCAL_HOST = "127.0.0.1";
    private static final List<String> LOOP_BACK_ADDRESS_LIST = new ArrayList<String>(3);
    private static final String LOCAL_IP_ADDRESS;

    public static String getLocalAddress() {
        return LOCAL_IP_ADDRESS;
    }

    public static String getLocalInetAddress() {
        String localIp = ArmsNetworkUtils.getSystemProperty("EAGLEEYE.LOCAL.IP");
        if (ArmsNetworkUtils.isNotBlank(localIp) && localIp.length() >= 7 && Character.isDigit(localIp.charAt(0)) && Character.isDigit(localIp.charAt(localIp.length() - 1))) {
            return localIp;
        }
        String inet = ArmsNetworkUtils.getSystemProperty("NETWORK.INTERFACE");
        if (ArmsNetworkUtils.isBlank(inet)) {
            inet = "eth0";
        }
        if (ArmsNetworkUtils.isNotBlank(inet)) {
            try {
                NetworkInterface ni = NetworkInterface.getByName(inet);
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            catch (Throwable ni) {
                // empty catch block
            }
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                String displayName = ni.getDisplayName();
                if (displayName != null && (displayName.startsWith("virbr") || displayName.equals("docker0"))) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static boolean isNotBlank(String str) {
        return !ArmsNetworkUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String getHostName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (UnknownHostException e) {
            return ArmsNetworkUtils.getMachineName();
        }
    }

    public static String getHostIp() {
        String hostIp;
        try {
            InetAddress thisIp = InetAddress.getLocalHost();
            hostIp = thisIp.getHostAddress();
        }
        catch (UnknownHostException e) {
            hostIp = "127.0.0.1";
        }
        return hostIp;
    }

    public static List<String> getHostIpList() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces == null) {
            return new ArrayList<String>();
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (ArmsNetworkUtils.isSkipNetworkInterface(current)) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                String hostAddress;
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || ArmsNetworkUtils.isLoopbackAddress(hostAddress = address.getHostAddress())) continue;
                result.add(address.getHostAddress());
            }
        }
        return result;
    }

    private static boolean isSkipNetworkInterface(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isLoopbackAddress(String ip) {
        if (ip == null) {
            return true;
        }
        return LOOP_BACK_ADDRESS_LIST.contains(ip);
    }

    @Deprecated
    public static String getMachineName() {
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            while (enet.hasMoreElements()) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress inet = eaddr.nextElement();
                    String canonicalHostName = inet.getCanonicalHostName();
                    if (canonicalHostName.equalsIgnoreCase(inet.getHostAddress())) continue;
                    return canonicalHostName;
                }
            }
            return ERROR_HOST_NAME;
        }
        catch (SocketException e) {
            return ERROR_HOST_NAME;
        }
    }

    private ArmsNetworkUtils() {
    }

    static {
        LOOP_BACK_ADDRESS_LIST.add("127.0.0.1");
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V4_2);
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V6);
        LOCAL_IP_ADDRESS = ArmsNetworkUtils.getLocalInetAddress();
    }
}

