/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class ArmsHostUtils {
    private ArmsHostUtils() {
    }

    public static String getMemInfo() {
        boolean ibmVendor = System.getProperty("java.vendor").contains("IBM");
        String totalMb = "0";
        try {
            OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            if (ibmVendor) {
                Class<?> beanClass = Class.forName("com.ibm.lang.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemory", new Class[0]);
                totalMb = String.valueOf((Long)method.invoke((Object)bean, new Object[0]) / 1024L / 1024L);
            } else {
                Class<?> beanClass = Class.forName("com.sun.management.OperatingSystemMXBean");
                Method method = beanClass.getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                totalMb = String.valueOf((Long)method.invoke((Object)bean, new Object[0]) / 1024L / 1024L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalMb;
    }

    public static String getCpuInfo() {
        return Integer.toString(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors());
    }
}

