/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.ArmsMD5;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.CRC64;
import java.io.File;

public class ArmsCommonUtils {
    private static boolean isEnvPrivate = false;

    public static String getAppId(String appName, String userId) {
        if (io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(appName) || io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(userId)) {
            return "";
        }
        String siteNameCode = ArmsMD5.getMD5String(appName + "token").substring(0, 15);
        String PID = ArmsCommonUtils.encodeUserId(userId) + "@" + siteNameCode;
        return PID;
    }

    public static String getArmsAppDataId(String appId) {
        if (!StringUtils.isEmptyOrNull(appId)) {
            String processedAppId = appId.replaceAll("@", "-");
            return "arms.trace." + processedAppId;
        }
        return "";
    }

    public static String getArmsCustomExtractDataId(String appId) {
        if (!StringUtils.isEmptyOrNull(appId)) {
            String processedAppId = appId.replaceAll("@", "-");
            return "arms.custom.extract." + processedAppId;
        }
        return "";
    }

    public static boolean glibcInstalled() {
        try {
            File lib = new File("/lib");
            File lib64 = new File("/lib64");
            File[] fs = lib.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    if (!f.getName().contains("musl") && !f.getName().contains("MUSL")) continue;
                    return false;
                }
            }
            if ((fs = lib64.listFiles()) != null) {
                for (File f : fs) {
                    if (!f.getName().contains("musl") && !f.getName().contains("MUSL")) continue;
                    return false;
                }
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static String getArmsHeapDumpDataId(String appId) {
        if (!StringUtils.isEmptyOrNull(appId)) {
            String processedAppId = appId.replaceAll("@", "-");
            return "arms.intactheap." + processedAppId;
        }
        return "";
    }

    public static String getArmsGlobalConfigDataId() {
        if (io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(AgentInfo.INSTANCE.getUserId())) {
            return "";
        }
        return String.format("arms.trace.%s.global", AgentInfo.INSTANCE.getUserId());
    }

    private static String encodeUserId(String userId) {
        if (isEnvPrivate) {
            return userId;
        }
        return Long.toString(Long.parseLong(userId), 36);
    }

    private static String decodeUserId(String str) {
        if (isEnvPrivate) {
            return str;
        }
        String decodedUserId = str;
        try {
            decodedUserId = String.valueOf(Long.parseLong(str, 36));
        }
        catch (Exception e) {
            isEnvPrivate = true;
        }
        return decodedUserId;
    }

    public static String getPID(String appName, String userId) {
        if (io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(appName) || io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(userId)) {
            return "";
        }
        String siteNameCode = ArmsMD5.getMD5String(appName + "token").substring(0, 15);
        String PID = ArmsCommonUtils.encodeUserId(userId) + "@" + siteNameCode;
        return PID;
    }

    public static String generateAppId(String userId, String namespace, String appName) {
        if (io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(appName) || io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(userId)) {
            return "";
        }
        if (io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils.isNullOrEmpty(namespace) || "default".equals(namespace)) {
            return Long.toString(Long.parseLong(userId), 36) + "@" + ArmsMD5.getMD5String(appName + "token").substring(0, 15);
        }
        return Long.toString(Long.parseLong(userId), 36) + "@" + ArmsMD5.getMD5String(namespace + ":" + appName + ":token").substring(0, 15);
    }

    public static String getUserId(String licenseKey) {
        int index;
        String userId = "";
        if (licenseKey != null && licenseKey.length() > 0 && (index = licenseKey.indexOf("@")) > 0) {
            String encodedUserId = licenseKey.substring(0, index);
            userId = ArmsCommonUtils.decodeUserId(encodedUserId);
        }
        return userId;
    }

    public static int getPort(int port, int defaultPort) {
        if (port <= 0) {
            return -1;
        }
        if (port == defaultPort) {
            return -1;
        }
        return port;
    }

    public static String encode(String str) {
        CRC64 crc = new CRC64();
        byte[] bytes = str.getBytes();
        crc.update(bytes, bytes.length);
        return Long.toHexString(crc.getValue());
    }

    public static String newAbbreviate(String str, int maxWidth) {
        if (str == null) {
            return "";
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth:" + maxWidth);
        }
        if (str.length() > maxWidth) {
            StringBuilder buffer = new StringBuilder(maxWidth + 10);
            buffer.append(str, 0, maxWidth);
            return buffer.toString();
        }
        return str;
    }

    private ArmsCommonUtils() {
    }
}

