/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsMultiThreadSpanEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsWallClockStatusType;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotProfiling;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.ProfilingRunningState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class HotSpotRecorder {
    private static final PatchLogger logger = PatchLogger.getLogger(HotSpotRecorder.class.getName());
    private static final HotSpotProfiling hotSpotRecordHandler = GlobalInstanceHolder.getInstance(HotSpotProfiling.class);
    private static final int MAX_SPAN_ID_STACK_SIZE = 3000;
    private static final int MAX_LOG_BUFFER_SIZE = 4000;
    private static final AtomicLong cnt1 = new AtomicLong(-1L);
    private static final AtomicLong cnt2 = new AtomicLong(-1L);
    private static SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
    private static final int THRESHOLD_EXCEPTION_TRACE = 0x7FFFFFFE;
    public static boolean isError = false;
    private static final ThreadLocal<Stack<String>> SPAN_STACK = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    public static final ThreadLocal<StringBuffer> LOG_BUFFER = new ThreadLocal<StringBuffer>(){

        @Override
        protected StringBuffer initialValue() {
            return new StringBuffer();
        }
    };
    private static final ThreadLocal<Integer> LOG_SEQ_NUM = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };

    private static int getNextNum() {
        int next = (LOG_SEQ_NUM.get() + 1) % 0x7FFFFFFE;
        LOG_SEQ_NUM.set(next);
        return next;
    }

    public static void setProfilingInfo(Span span, boolean fromAttach) {
        SpanContext spanContext = span.getSpanContext();
        boolean isSampled = spanContext.isSampled();
        Stack<String> stack = SPAN_STACK.get();
        HotSpotRecorder.printLog("first in fromAttach=" + fromAttach, span, null, null, LOG_BUFFER.get());
        if (ProfilingRunningState.isWallClockRunning && isSampled) {
            String spanId = spanContext.getSpanId();
            String traceId = spanContext.getTraceId();
            long spanIdValue = OtelEncodingUtils.longFromBase16String(spanId, 0);
            HotSpotRecorder.printLog("second in fromAttach=" + fromAttach, span, stack, null, LOG_BUFFER.get());
            if (stack.size() == 0) {
                String value;
                if (hotSpotRecordHandler != null && !hotSpotRecordHandler.checkCurrentThread()) {
                    HotSpotRecorder.printLog("third in fromAttach=" + fromAttach, span, stack, null, LOG_BUFFER.get());
                    hotSpotRecordHandler.recordHotSpotStart(traceId, spanIdValue);
                    if (!fromAttach) {
                        stack.push(spanId);
                    }
                }
                if ((value = spanReader.getAttribute(span, AttributeKey.stringKey("wallClock"))) == null) {
                    span.setAttribute("wallClock", String.valueOf(ArmsWallClockStatusType.NOMINEE.getStatus()));
                } else {
                    span.setAttribute("multiThread", String.valueOf(ArmsMultiThreadSpanEnum.MULTI_THREAD.getFlag()));
                }
            }
            if (stack.size() < 3000) {
                if (fromAttach) {
                    stack.push(spanId);
                    HotSpotRecorder.printLog("fourth in", span, stack, null, LOG_BUFFER.get());
                }
            } else if (cnt2.incrementAndGet() % 0x7FFFFFFEL == 0L) {
                HotSpotRecorder.printLog("warn unexpected scenario in stack is greater than 3000", span, SPAN_STACK.get(), null, LOG_BUFFER.get());
                cnt2.set(0L);
            }
        } else if (stack.size() > 0) {
            stack.clear();
            if (hotSpotRecordHandler != null) {
                hotSpotRecordHandler.removeCurrentThread();
            }
        }
    }

    public static void clearProfilingInfo(Span span) {
        if (ProfilingRunningState.isWallClockRunning && span.getSpanContext().isSampled()) {
            String popSpanId;
            String spanId = span.getSpanContext().getSpanId();
            Stack<String> stack = SPAN_STACK.get();
            HotSpotRecorder.printLog("first out", span, SPAN_STACK.get(), null, LOG_BUFFER.get());
            String string = popSpanId = stack.size() != 0 ? stack.pop() : null;
            if (popSpanId != null && spanId.equals(popSpanId)) {
                HotSpotRecorder.setWallClockPicked(span, "out1");
                if (stack.size() > 0) {
                    HotSpotRecorder.printLog("third out", span, stack, null, LOG_BUFFER.get());
                    return;
                }
            } else {
                HotSpotRecorder.printLog("unexpected scenario in closing the span", span, SPAN_STACK.get(), null, LOG_BUFFER.get());
                stack.clear();
            }
        } else if (!span.getSpanContext().isSampled()) {
            HotSpotRecorder.printLog("fourth out", span, SPAN_STACK.get(), null, LOG_BUFFER.get());
        }
        Stack<String> stack = SPAN_STACK.get();
        if (stack.size() > 0) {
            HotSpotRecorder.printLog("unexpected scenario in clear stack", span, SPAN_STACK.get(), null, LOG_BUFFER.get());
            stack.clear();
        }
        if (hotSpotRecordHandler != null) {
            HotSpotRecorder.printLog("fifth out", span, stack, null, LOG_BUFFER.get());
            HotSpotRecorder.setWallClockPicked(span, "out2");
            hotSpotRecordHandler.recordHotSpotEnd();
        }
    }

    private static void setWallClockPicked(Span span, String label) {
        Stack<String> stack = SPAN_STACK.get();
        String value = spanReader.getAttribute(span, AttributeKey.stringKey("wallClock"));
        if (value != null && ArmsWallClockStatusType.NOMINEE.getStatus() == Integer.parseInt(value)) {
            long actualSpanId = OtelEncodingUtils.longFromBase16String(span.getSpanContext().getSpanId(), 0);
            int samplesCount = hotSpotRecordHandler != null ? hotSpotRecordHandler.getSampleCount(span.getSpanContext().getTraceId(), actualSpanId) : 0;
            HotSpotRecorder.printLog("set first " + label + " samplesCount=" + samplesCount + " checkCurrentThread=" + hotSpotRecordHandler.checkCurrentThread() + " actualSpanId=" + actualSpanId, span, stack, null, LOG_BUFFER.get());
            if (samplesCount > 0) {
                HotSpotRecorder.printLog("set second " + label + " samplesCount=" + samplesCount, span, stack, null, LOG_BUFFER.get());
                span.setAttribute("wallClock", String.valueOf(ArmsWallClockStatusType.PICKED.getStatus()));
            }
        }
    }

    public static void setWallClockAttribute(Span span) {
        if (!ProfilingRunningState.isWallClockRunning || !span.getSpanContext().isSampled()) {
            return;
        }
        HotSpotRecorder.printLog("first attribute", span, null, null, LOG_BUFFER.get());
        HotSpotRecorder.setWallClockPicked(span, "attribute");
    }

    public static void printLog(String position, Span span, Stack<String> stack, Boolean isCollected, StringBuffer buffer) {
        if (!isError && !"warn unexpected scenario".startsWith(position)) {
            return;
        }
        SpanContext spanContext = span.getSpanContext();
        boolean isSampled = spanContext.isSampled();
        String spanId = spanContext.getSpanId();
        String traceId = spanContext.getTraceId();
        String spanName = GlobalInstanceHolder.getInstance(SpanReader.class).readSpanName(span);
        StringBuilder logString = new StringBuilder(System.currentTimeMillis() + "|" + Thread.currentThread().getName() + "|" + position + " traceId=" + traceId + " spanId=" + spanId + " isSampled=" + isSampled + " spanName=" + spanName);
        if (stack != null) {
            logString.append(" stack.size=" + stack.size() + " stack=" + stack);
        }
        if (isCollected != null) {
            logString.append(" isCollected=" + isCollected);
        }
        if (!isError) {
            logger.warning(logString.toString());
        } else {
            if (buffer.length() > 4000) {
                logger.log(Level.SEVERE, "[CP][DEBUG]#" + HotSpotRecorder.getNextNum() + "\n" + buffer);
                buffer.setLength(0);
            }
            buffer.append(logString + "\n");
        }
    }
}

