/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.extract.enums.ExtractTypeEnum;

public enum ExtractSourceEnum {
    UNKNOWN(-1, 0),
    PARAMETER(0, 25),
    COOKIE(1, 3),
    HEADER(2, 51),
    BODY(3, 3),
    MESSAGE(4, 4),
    RETURN(5, 8);

    public final int code;
    public final int supportSource;

    private ExtractSourceEnum(int code, int supportSource) {
        this.code = code;
        this.supportSource = supportSource;
    }

    public boolean isSupported(ExtractTypeEnum type) {
        return (this.supportSource & type.code) > 0;
    }

    public static ExtractSourceEnum getEnumByName(String name) {
        try {
            return ExtractSourceEnum.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}

