/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum UniRpcType {
    HTTP_INCOME(0, UniCallKind.HTTP, "http", "HTTP"),
    HTTP(0, UniCallKind.HTTP, "http", "HTTP"),
    HTTP_CLIENT(25, UniCallKind.HTTP_CLIENT, "http_client", "HTTP"),
    HSF_CONSUMER(1, UniCallKind.RPC_CLIENT, "hsf_client", "HSF"),
    HSF_PROVIDER(2, UniCallKind.RPC, "hsf", "HSF"),
    LOCAL_CALL(40, UniCallKind.INTERNAL, "local", "LOCAL"),
    DB2(52, UniCallKind.SQL, "DB2", "DB2"),
    INFORMIX(53, UniCallKind.SQL, "Informix", "INFORMIX"),
    SEQUOIADB(54, UniCallKind.SQL, "SequoiaDB", "SEQUOIADB"),
    GBASE(55, UniCallKind.SQL, "Gbase", "GBASE"),
    GAUSSDB(56, UniCallKind.SQL, "GaussDB", "GAUSSDB"),
    KINGBASE(57, UniCallKind.SQL, "KingBase", "KINGBASE"),
    INFLUXDB(58, UniCallKind.SQL, "influxdb", "INFLUXDB"),
    CLICKHOUSE(59, UniCallKind.SQL, "clickhouse", "CLICKHOUSE"),
    MYSQL(60, UniCallKind.SQL, "mysql", "MYSQL"),
    MYBATIS(61, UniCallKind.SQL, "mybatis", "MYBATIS"),
    ORACLE(62, UniCallKind.SQL, "oracle", "ORACLE"),
    POSTGRESQL(63, UniCallKind.SQL, "postgresql", "POSTGRESQL"),
    MONGODB(64, UniCallKind.NO_SQL, "mongodb", "MONGODB"),
    PPAS(65, UniCallKind.SQL, "ppas", "PPAS"),
    SQLSERVER(66, UniCallKind.SQL, "sqlserver", "SQLSERVER"),
    MARIADB(67, UniCallKind.SQL, "mariadb", "MARIADB"),
    DMDB(68, UniCallKind.SQL, "dmdb", "DMDB"),
    OCEANBASE(69, UniCallKind.SQL, "oceanbase", "OCEANBASE"),
    REDIS(70, UniCallKind.CACHE, "redis", "REDIS"),
    MEMCACHED(71, UniCallKind.CACHE, "memcached", "MEMCACHED"),
    ELASTICSEARCH(72, UniCallKind.NO_SQL, "elasticsearch", "ELASTICSEARCH"),
    KUDU(73, UniCallKind.SQL, "kudu", "KUDU"),
    TDDL(4, UniCallKind.SQL, "tddl", "TDDL"),
    TAIR(5, UniCallKind.CACHE, "tair", "TAIR"),
    S_METAQ(13, UniCallKind.PRODUCER, "mq_client", "MQ"),
    R_METAQ(252, UniCallKind.CONSUMER, "mq", "MQ"),
    S_KAFKA(23, UniCallKind.PRODUCER, "kafka_client", "KAFKA"),
    R_KAFKA(256, UniCallKind.CONSUMER, "kafka", "KAFKA"),
    S_NOTIFY(3, UniCallKind.PRODUCER, "notify_client", "NOTIFY"),
    R_NOTIFY(254, UniCallKind.CONSUMER, "notify", "NOTIFY"),
    DUBBO_CONSUMER(7, UniCallKind.RPC_CLIENT, "dubbo_client", "DUBBO"),
    DUBBO_PROVIDER(8, UniCallKind.RPC, "dubbo", "DUBBO"),
    DSF_CONSUMER(11, UniCallKind.RPC_CLIENT, "dsf_client", "DSF"),
    DSF_PROVIDER(12, UniCallKind.RPC, "dsf", "DSF"),
    GRPC_PROVIDER(9, UniCallKind.RPC, "grpc", "GRPC"),
    GRPC_CONSUMER(10, UniCallKind.RPC_CLIENT, "grpc_client", "GRPC"),
    THRIFT_PROVIDER(16, UniCallKind.RPC, "thrift", "THRIFT"),
    THRIFT_CONSUMER(17, UniCallKind.RPC_CLIENT, "thrift_client", "THRIFT"),
    SOFA_PROVIDER(18, UniCallKind.RPC, "sofa", "SOFA"),
    SOFA_CONSUMER(19, UniCallKind.RPC_CLIENT, "sofa_client", "SOFA"),
    UNKNOWN(-1, UniCallKind.UNKNOWN, "unknown", "UNKNOWN"),
    USER_METHOD(98, UniCallKind.CUSTOM_ENTRY, "user_method", "USER_METHOD"),
    CLIENT(101, UniCallKind.CLIENT, "client", ""),
    SERVER(102, UniCallKind.SERVER, "server", ""),
    PRODUCER(103, UniCallKind.PRODUCER, "producer", ""),
    CONSUMER(104, UniCallKind.CONSUMER, "consumer", ""),
    DB(105, UniCallKind.DB, "db", "DB"),
    XTRACE_OTHER(106, UniCallKind.SPAN, "xtrace_other", ""),
    SPAN(107, UniCallKind.SPAN, "span", ""),
    SQL(108, UniCallKind.SQL, "sql", ""),
    SCHEDULERX(1301, UniCallKind.SCHEDULE, "SchedulerX", "SCHEDULERX"),
    XXLJOB(1302, UniCallKind.SCHEDULE, "XXL_Job", "XXLJOB"),
    SPRING_SCHEDULED(1303, UniCallKind.SCHEDULE, "Spring_Scheduled", "SPRING_SCHEDULED"),
    JDK_TIMER(1308, UniCallKind.SCHEDULE, "Jdk_Timer", "JDK_TIMER"),
    QUARTZ(1304, UniCallKind.SCHEDULE, "Quartz", "QUARTZ"),
    ELASTICJOB(1305, UniCallKind.SCHEDULE, "ElasticJob", "ELASTICJOB"),
    LLM(2100, UniCallKind.CUSTOM_ENTRY, "llm", "LLM"),
    GENAI(2110, UniCallKind.CUSTOM_ENTRY, "gen_ai", "GENAI"),
    HIKARICP(6060, UniCallKind.INTERNAL, "Hikaricp", "HIKARICP"),
    DRUID(6062, UniCallKind.INTERNAL, "Druid", "DRUID");

    private final int code;
    private final UniCallKind kind;
    private final String callType;
    private final String name;
    private final String protocol;
    private static final Map<Integer, UniRpcType> rpcTypeMap;

    private UniRpcType(int code, UniCallKind kind, String callType, String protocol) {
        this.code = code;
        this.kind = kind;
        this.callType = callType;
        this.protocol = protocol;
        this.name = callType;
    }

    public static UniRpcType findByCode(int code) {
        UniRpcType rpcType = rpcTypeMap.get(code);
        if (rpcType == null) {
            rpcType = UNKNOWN;
        }
        return rpcType;
    }

    public static UniRpcType getByCode(int code) {
        return UniRpcType.findByCode(code);
    }

    public static UniRpcType getByName(String name) {
        return Arrays.stream(UniRpcType.values()).filter(e -> e.getName().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
    }

    public String getCodeAsStr() {
        return String.valueOf(this.code).intern();
    }

    public static boolean isDbType(int code) {
        UniRpcType rpcType = UniRpcType.findByCode(code);
        return UniCallKind.DB.equals((Object)rpcType.kind) || UniCallKind.SQL.equals((Object)rpcType.kind) || UniCallKind.NO_SQL.equals((Object)rpcType.kind) || UniCallKind.CACHE.equals((Object)rpcType.kind);
    }

    public static boolean isDbType(UniRpcType rpcType) {
        return UniCallKind.DB.equals((Object)rpcType.kind) || UniCallKind.SQL.equals((Object)rpcType.kind) || UniCallKind.NO_SQL.equals((Object)rpcType.kind) || UniCallKind.CACHE.equals((Object)rpcType.kind);
    }

    public static void main(String[] args) {
        List codes = Arrays.stream(UniRpcType.values()).map(e -> e.getCode()).collect(Collectors.toList());
        Collections.sort(codes);
        System.out.println(codes);
    }

    public int getCode() {
        return this.code;
    }

    public UniCallKind getKind() {
        return this.kind;
    }

    public String getCallType() {
        return this.callType;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    static {
        rpcTypeMap = new HashMap<Integer, UniRpcType>();
        for (UniRpcType rpcType : UniRpcType.values()) {
            rpcTypeMap.put(rpcType.code, rpcType);
        }
    }
}

