/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums;

import java.util.Arrays;

public enum UniCallKind {
    UNKNOWN("unknown"),
    CUSTOM_ENTRY("custom_entry"),
    HTTP("http"),
    HTTP_CLIENT("http_client"),
    RPC("rpc"),
    RPC_CLIENT("rpc_client"),
    SQL("sql"),
    NO_SQL("nosql"),
    CACHE("cache"),
    PRODUCER("producer"),
    CONSUMER("consumer"),
    SCHEDULE("schedule"),
    INTERNAL("internal"),
    SPAN("span"),
    CLIENT("client"),
    SERVER("server"),
    DB("db");

    private String name;

    private UniCallKind(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isIncome(String callKind) {
        return callKind != null && (callKind.equalsIgnoreCase(HTTP.getName()) || callKind.equalsIgnoreCase(RPC.getName()) || callKind.equalsIgnoreCase(CONSUMER.getName()) || callKind.equalsIgnoreCase(SCHEDULE.getName()) || callKind.equalsIgnoreCase(SERVER.getName()));
    }

    public static boolean isDB(UniCallKind kind) {
        return DB.equals((Object)kind) || SQL.equals((Object)kind) || NO_SQL.equals((Object)kind) || CACHE.equals((Object)kind);
    }

    public static UniCallKind findByName(String name) {
        return Arrays.stream(UniCallKind.values()).filter(e -> e.getName().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
    }
}

