/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.UniCallKind;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ArmsRpcTypeEnum {
    HTTP_INCOME(0, "HTTP", "arms.rpcType.httpEntry", "http", true, true, UniCallKind.HTTP),
    HTTP(25, "HTTP", "arms.rpcType.invokeHTTP", "http_client", false, false, UniCallKind.HTTP_CLIENT),
    HSF_CONSUMER(1, "HSF", "arms.rpcType.invokeHSF", "hsf_client", false, false, UniCallKind.RPC),
    HSF_PROVIDER(2, "HSF", "arms.rpcType.provideHSF", "hsf", true, true, UniCallKind.RPC_CLIENT),
    LOCAL_CALL(40, "LOCAL", "arms.rpcType.invokeLocalAPI", "local", true, false, UniCallKind.INTERNAL),
    ASYNC_CALL(41, "ASYNC", "arms.rpcType.invokeAsync", "async", true, false, UniCallKind.INTERNAL),
    DB2(52, "DB2", "arms.rpcType.invokeDB2", "DB2", true, false, UniCallKind.DB),
    INFORMIX(53, "INFORMIX", "arms.rpcType.invokeINFORMIX", "Informix", true, false, UniCallKind.DB),
    SEQUOIADB(54, "SEQUOIADB", "arms.rpcType.invokeSEQUOIADB", "SequoiaDB", true, false, UniCallKind.DB),
    GBASE(55, "GBASE", "arms.rpcType.invokeGBASE", "Gbase", true, false, UniCallKind.DB),
    GAUSSDB(56, "GAUSSDB", "arms.rpcType.invokeGAUSSDB", "GaussDB", true, false, UniCallKind.DB),
    KINGBASE(57, "KINGBASE", "arms.rpcType.invokeKINGBASE", "KingBase", true, false, UniCallKind.DB),
    INFLUXDB(58, "INFLUXDB", "arms.rpcType.invokeINFUXDB", "influxdb", true, false, UniCallKind.DB),
    CLICKHOUSE(59, "CLICKHOUSE", "arms.rpcType.invokeCLICKHOUSE", "clickhouse", true, false, UniCallKind.DB),
    MYSQL(60, "MYSQL", "arms.rpcType.invokeMYSQL", "mysql", true, false, UniCallKind.DB),
    MYBATIS(61, "MYBATIS", "arms.rpcType.invokeMYSQL", "mybatis", true, false, UniCallKind.INTERNAL),
    ORACLE(62, "ORACLE", "arms.rpcType.invokeORACLE", "oracle", true, false, UniCallKind.DB),
    POSTGRESQL(63, "POSTGRESQL", "arms.rpcType.invokePOSTGRESQL", "postgresql", true, false, UniCallKind.DB),
    MONGODB(64, "MONGODB", "arms.rpcType.invokeMONGODB", "mongodb", true, false, UniCallKind.NO_SQL),
    PPAS(65, "PPAS", "arms.rpcType.invokePPAS", "ppas", true, false, UniCallKind.DB),
    SQLSERVER(66, "SQLSERVER", "arms.rpcType.invokeSQLSERVER", "sqlserver", true, false, UniCallKind.DB),
    MARIADB(67, "MARIADB", "arms.rpcType.invokeMARIADB", "mariadb", true, false, UniCallKind.DB),
    DMDB(68, "DMDB", "arms.rpcType.invokeDMDB", "dmdb", true, false, UniCallKind.DB),
    OCEANBASE(69, "OCEANBASE", "arms.rpcType.invokeOCEANBASE", "oceanbase", true, false, UniCallKind.DB),
    REDIS(70, "REDIS", "arms.rpcType.invokeREDIS", "redis", true, false, UniCallKind.NO_SQL),
    MEMCACHED(71, "MEMCACHED", "arms.rpcType.invokeMEMCACHED", "memcached", true, false, UniCallKind.NO_SQL),
    ELASTICSEARCH(72, "ELASTICSEARCH", "arms.rpcType.invokeELASTICSEARCH", "elasticsearch", true, false, UniCallKind.NO_SQL),
    KUDU(73, "KUDU", "arms.rpcType.invokeKUDU", "kudu", true, false, UniCallKind.DB),
    CASSANDRA(74, "CASSANDRA", "arms.rpcType.invokeCassandra", "cassandra", true, false, UniCallKind.DB),
    LINDORM(75, "LINDORM", "arms.rpcType.invokeCassandra", "lindorm", true, false, UniCallKind.DB),
    TDDL(4, "TDDL", "arms.rpcType.invodeTDDL", "tddl", true, false, UniCallKind.DB),
    TAIR(5, "TAIR", "arms.rpcType.invokeTAIR", "tair", true, false, UniCallKind.NO_SQL),
    S_METAQ(13, "MQ", "arms.rpcType.sendMQ", "mq_client", false, false, UniCallKind.PRODUCER),
    R_METAQ(252, "MQ", "arms.rpcType.recMQ", "mq", true, true, UniCallKind.CONSUMER),
    S_KAFKA(23, "KAFKA", "arms.rpcType.sendKafka", "kafka_client", false, false, UniCallKind.PRODUCER),
    R_KAFKA(256, "KAFKA", "arms.rpcType.recKafka", "kafka", true, true, UniCallKind.CONSUMER),
    S_NOTIFY(3, "NOTIFY", "arms.rpcType.sendNotify", "notify_client", false, false, UniCallKind.PRODUCER),
    R_NOTIFY(254, "NOTIFY", "arms.rpcType.recNotify", "notify", true, true, UniCallKind.CONSUMER),
    DUBBO_CONSUMER(7, "DUBBO", "arms.rpcType.invokeDUBBO", "dubbo_client", false, false, UniCallKind.RPC_CLIENT),
    DUBBO_PROVIDER(8, "DUBBO", "arms.rpcType.provideDUBBO", "dubbo", true, true, UniCallKind.RPC),
    DSF_CONSUMER(11, "DSF", "arms.rpcType.invokeDSF", "dsf_client", false, false, UniCallKind.RPC_CLIENT),
    DSF_PROVIDER(12, "DSF", "arms.rpcType.provideDSF", "dsf", true, true, UniCallKind.RPC),
    GRPC_PROVIDER(9, "GRPC", "arms.rpcType.provideGRPC", "grpc", true, true, UniCallKind.RPC),
    GRPC_CONSUMER(10, "GRPC", "arms.rpcType.invokeGRPC", "grpc_client", false, false, UniCallKind.RPC_CLIENT),
    THRIFT_PROVIDER(16, "THRIFT", "arms.rpcType.provideTHRIFT", "thrift", true, true, UniCallKind.RPC),
    THRIFT_CONSUMER(17, "THRIFT", "arms.rpcType.invokeTHRIFT", "thrift_client", false, false, UniCallKind.RPC_CLIENT),
    SOFA_PROVIDER(18, "SOFA", "arms.rpcType.provideSOFA", "sofa", true, true, UniCallKind.RPC),
    SOFA_CONSUMER(19, "SOFA", "arms.rpcType.invokeSOFA", "sofa_client", false, false, UniCallKind.RPC_CLIENT),
    UNKNOWN(-1, "UNKNOWN", "arms.rpcType.unknowRPCType", "unknown", true, false, UniCallKind.UNKNOWN),
    USER_METHOD(98, "USER_METHOD", "arms.rpcType.customMethod", "user_method", true, true, UniCallKind.CUSTOM_ENTRY),
    ROOT(100, "", "arms.rpcType.root", "root", true, true, UniCallKind.INTERNAL),
    CLIENT(101, "", "arms.rpcType.client", "client", false, false, UniCallKind.RPC_CLIENT),
    SERVER(102, "", "arms.rpcType.server", "server", true, true, UniCallKind.RPC),
    PRODUCER(103, "", "arms.rpcType.producer", "producer", true, false, UniCallKind.PRODUCER),
    CONSUMER(104, "", "arms.rpcType.consumer", "consumer", false, true, UniCallKind.CONSUMER),
    DB(105, "DB", "arms.rpcType.db", "db", true, false, UniCallKind.DB),
    XTRACE_OTHER(106, "", "arms.rpcType.xtraceOther", "xtrace_other", true, false, UniCallKind.UNKNOWN),
    FRONT(-2, "FRONT", "arms.rpcType.front", "front", true, true, UniCallKind.UNKNOWN),
    SCHEDULERX(1301, "SCHEDULERX", "arms.rpcType.schedulerx", "schedulerx", true, true, UniCallKind.SCHEDULE),
    APP(-3, "APP", "arms.rpcType.app", "app", true, true, UniCallKind.UNKNOWN),
    XXLJOB(1302, "XXLJOB", "arms.rpcType.xxljob", "XXL_Job", true, true, UniCallKind.SCHEDULE),
    SPRING_SCHEDULED(1303, "SPRING_SCHEDULED", "arms.rpcType.springScheduled", "Spring_Scheduled", true, true, UniCallKind.SCHEDULE),
    QUARTZ(1304, "QUARTZ", "arms.rpcType.quartz", "Quartz", true, true, UniCallKind.SCHEDULE),
    ELASTICJOB(1305, "ELASTICJOB", "arms.rpcType.elasticjob", "ElasticJob", true, true, UniCallKind.SCHEDULE),
    JDK_TIMER(1308, "JDK_TIMER", "arms.rpcType.jdkTimer", "Jdk_Timer", true, true, UniCallKind.SCHEDULE),
    LLM(2100, "LLM", "arms.rpcType.llm", "llm", false, false, UniCallKind.CUSTOM_ENTRY),
    GENAI(2110, "GEN_AI", "arms.rpcType.gen_ai", "gen_ai", false, false, UniCallKind.CUSTOM_ENTRY),
    HIKARICP(6060, "HIKARICP", "arms.rpcType.hikaricp", "Hikaricp", true, false, UniCallKind.INTERNAL),
    DRUID(6062, "DRUID", "arms.rpcType.druid", "Druid", true, false, UniCallKind.INTERNAL);

    private final Integer code;
    private final String protocol;
    private final String desc;
    private final String name;
    private final boolean compressible;
    private final boolean incoming;
    private final UniCallKind uniCallKind;
    public static final Map<Integer, ArmsRpcTypeEnum> enumRpcType;
    public static final Set<Integer> spanCompressibleRpcType;
    public static final Set<Integer> incomingRpcTypes;
    private static ArmsRpcTypeEnum[] rpcTypeEnumArray;

    private ArmsRpcTypeEnum(Integer code, String protocol, String desc, String name, boolean compressible, boolean incoming) {
        this(code, protocol, desc, name, compressible, incoming, UniCallKind.UNKNOWN);
    }

    private ArmsRpcTypeEnum(Integer code, String protocol, String desc, String name, boolean compressible, boolean incoming, UniCallKind uniCallKind) {
        this.code = code;
        this.protocol = protocol;
        this.desc = desc;
        this.name = name;
        this.compressible = compressible;
        this.incoming = incoming;
        this.uniCallKind = uniCallKind;
    }

    public static ArmsRpcTypeEnum fromCode(Integer code) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (!ct.code.equals(code)) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByName(String name) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (!ct.name.equalsIgnoreCase(name)) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByCode(int code) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (ct.code != code) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByIndex(int idx) {
        if (idx < rpcTypeEnumArray.length) {
            return rpcTypeEnumArray[idx];
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByIndex(Long idx) {
        if (idx == null) {
            return UNKNOWN;
        }
        if (idx < (long)rpcTypeEnumArray.length) {
            return rpcTypeEnumArray[idx.intValue()];
        }
        return UNKNOWN;
    }

    public static boolean isInSpanCompressible(int code) {
        return spanCompressibleRpcType.contains(code);
    }

    public static boolean isIncomeRpcType(int code) {
        return incomingRpcTypes.contains(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    public UniCallKind getUniCallKind() {
        return this.uniCallKind;
    }

    static {
        enumRpcType = new HashMap<Integer, ArmsRpcTypeEnum>();
        spanCompressibleRpcType = new HashSet<Integer>();
        incomingRpcTypes = new HashSet<Integer>();
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (ct.incoming) {
                incomingRpcTypes.add(ct.getCode());
            }
            if (ct.compressible) {
                spanCompressibleRpcType.add(ct.getCode());
            }
            enumRpcType.put(ct.getCode(), ct);
        }
        rpcTypeEnumArray = ArmsRpcTypeEnum.values();
    }
}

