/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums;

public enum ArmsJvmType {
    UNKNOWN(null),
    IBM("IBM"),
    OPENJDK("OpenJDK"),
    ORACLE("HotSpot"),
    OPENJ9("OpenJ9");

    private final String inclusiveString;

    private ArmsJvmType(String inclusiveString) {
        this.inclusiveString = inclusiveString;
    }

    public static ArmsJvmType fromVendor(String vendorName) {
        if (vendorName == null) {
            return UNKNOWN;
        }
        String vendorNameTrimmed = vendorName.trim();
        for (ArmsJvmType armsJvmType : ArmsJvmType.values()) {
            if (!armsJvmType.toString().equalsIgnoreCase(vendorNameTrimmed)) continue;
            return armsJvmType;
        }
        return UNKNOWN;
    }

    public static ArmsJvmType fromVmName(String vmName) {
        if (vmName == null) {
            return UNKNOWN;
        }
        for (ArmsJvmType armsJvmType : ArmsJvmType.values()) {
            if (armsJvmType.inclusiveString == null || !vmName.contains(armsJvmType.inclusiveString)) continue;
            return armsJvmType;
        }
        return UNKNOWN;
    }
}

