/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.SkywalkingContext;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

public class SkywalkingSpanBuilder {
    public SkywalkingContext parentContext;
    private static final long INVALID_ID = 0L;
    private static final Supplier<Random> randomSupplier = ThreadLocalRandom::current;

    public SkywalkingSpanBuilder(SkywalkingContext skywalkingContext) {
        this.parentContext = skywalkingContext;
    }

    public SkywalkingContext startSpan() {
        Integer spanId = this.generateSpanId();
        String traceId = this.parentContext.getTraceId();
        String sampleStr = this.parentContext.getSample();
        String segmentId = this.parentContext.getCurrentSegmentId() != null ? this.parentContext.getCurrentSegmentId() : this.parentContext.getSegmentId();
        SkywalkingContext skywalkingContext = new SkywalkingContext(sampleStr, traceId, segmentId, spanId);
        return skywalkingContext;
    }

    public Integer generateSpanId() {
        int id;
        Random random = randomSupplier.get();
        while ((long)(id = random.nextInt()) == 0L) {
        }
        return Math.abs(id);
    }
}

