/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class SkywalkingIdGenerator {
    private static volatile List<String> IPV4_LIST;
    public static String SERVICE_INSTANCE;
    private static final String PROCESS_ID;
    private static final ThreadLocal<IDContext> THREAD_ID_SEQUENCE;

    private SkywalkingIdGenerator() {
    }

    public static String generateInstance() {
        if (SERVICE_INSTANCE == null) {
            SERVICE_INSTANCE = UUID.randomUUID().toString().replaceAll("-", "") + "@" + SkywalkingIdGenerator.getIPV4();
        }
        return SERVICE_INSTANCE;
    }

    public static String getIPV4() {
        List<String> allIPV4 = SkywalkingIdGenerator.getAllIPV4();
        if (allIPV4.size() > 0) {
            return allIPV4.get(0);
        }
        return "no-hostname";
    }

    public static List<String> getAllIPV4() {
        if (IPV4_LIST == null) {
            IPV4_LIST = new LinkedList<String>();
            try {
                Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
                while (interfs.hasMoreElements()) {
                    NetworkInterface networkInterface = interfs.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String addressStr;
                        InetAddress address = inetAddresses.nextElement();
                        if (!(address instanceof Inet4Address) || "127.0.0.1".equals(addressStr = address.getHostAddress()) || "localhost".equals(addressStr)) continue;
                        IPV4_LIST.add(addressStr);
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return IPV4_LIST;
    }

    public static String generate() {
        return SkywalkingIdGenerator.join('.', PROCESS_ID, String.valueOf(Thread.currentThread().getId()), String.valueOf(THREAD_ID_SEQUENCE.get().nextSeq()));
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s : strings) {
            if (s == null) continue;
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        if (strings[0] != null) {
            sb.append(strings[0]);
        }
        for (int i = 1; i < strings.length; ++i) {
            if (!SkywalkingIdGenerator.isEmpty(strings[i])) {
                sb.append(delimiter).append(strings[i]);
                continue;
            }
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static {
        PROCESS_ID = UUID.randomUUID().toString().replaceAll("-", "");
        THREAD_ID_SEQUENCE = ThreadLocal.withInitial(() -> new IDContext(System.currentTimeMillis(), 0));
    }

    static class IDContext {
        private long lastTimestamp;
        private short threadSeq;
        private long lastShiftTimestamp;
        private int lastShiftValue;

        IDContext(long lastTimestamp, short threadSeq) {
            this.lastTimestamp = lastTimestamp;
            this.threadSeq = threadSeq;
        }

        long nextSeq() {
            return this.timestamp() * 10000L + (long)this.nextThreadSeq();
        }

        private long timestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTimestamp) {
                if (this.lastShiftTimestamp != currentTimeMillis) {
                    ++this.lastShiftValue;
                    this.lastShiftTimestamp = currentTimeMillis;
                }
                return this.lastShiftValue;
            }
            this.lastTimestamp = currentTimeMillis;
            return this.lastTimestamp;
        }

        private short nextThreadSeq() {
            if (this.threadSeq == 10000) {
                this.threadSeq = 0;
            }
            short s = this.threadSeq;
            this.threadSeq = (short)(s + 1);
            return s;
        }
    }
}

