/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ArmsThreadFactory
implements ThreadFactory {
    private final String threadName;
    private final boolean daemon;
    private ClassLoader contextClassLoader;
    private Integer priority;
    private final AtomicInteger counter = new AtomicInteger();
    private static final String THREAD_PREFIX = "aliyun-java-agent-apm-";
    public static final ThreadGroup group = new ThreadGroup("aliyun-java-agent-apm-thread-group");

    public ArmsThreadFactory(String threadName, boolean daemon) {
        if (StringUtils.isNullOrEmpty(threadName)) {
            throw new NullPointerException("threadName");
        }
        this.threadName = threadName;
        this.daemon = daemon;
    }

    public ArmsThreadFactory(String threadName, boolean daemon, ClassLoader contextClassLoader) {
        this(threadName, daemon);
        this.contextClassLoader = contextClassLoader;
    }

    public ArmsThreadFactory(String threadName, boolean daemon, int priority) {
        this(threadName, daemon);
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String newThreadName = this.createThreadName();
        Thread thread = new Thread(group, runnable, newThreadName);
        if (this.daemon) {
            thread.setDaemon(true);
        }
        if (this.contextClassLoader != null) {
            thread.setContextClassLoader(this.contextClassLoader);
        }
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        return thread;
    }

    private String createThreadName() {
        StringBuilder stringBuilder = new StringBuilder(THREAD_PREFIX);
        stringBuilder.append(this.threadName);
        stringBuilder.append("-");
        stringBuilder.append(this.counter.incrementAndGet());
        return stringBuilder.toString();
    }
}

