/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.GlobalOpenTelemetryStatusHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SelfMonitorTrigger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.AliveInstanceCounter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SampleInfoHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsExporterEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicLong;

public class SelfMonitorMetrics {
    public static final String AGENT_CONSUMED_CPU_TIME = "self_monitor_agent_consumed_cpu_time";
    public static final String AGENT_COU_CORES = "self_monitor_agent_cpu_cores";
    public static final String AGENT_CONSUMED_MEMORY = "self_monitor_agent_consumed_memory";
    public static final String AGENT_START_RT = "self_monitor_agent_instrumentor_start_rt";
    public static final String AGENT_END_RT = "self_monitor_agent_instrumentor_end_rt";
    public static final long SELF_MONITOR_SAMPLE_RATE = ConfigPropertiesUtil.getLong("profiler.selfmonitor.sample.rate", 1000L);
    private static SelfMonitorTrigger selfMonitorTrigger;
    public static AtomicLong spanMemoryCount;
    private static LongCounter instrumenter_start_count;
    private static LongCounter instrumenter_end_count;
    private static LongCounter instrumenter_start_rt;
    private static LongCounter instrumenter_end_rt;
    private static LongCounter advice_threw_exception_count;
    private static LongCounter sls_log_report_lines;
    private static LongCounter sls_log_report_count;
    private static LongCounter logger_warn_log_count;
    private static LongCounter logger_error_log_count;
    private static final AttributeKey<String> EXCEPTION_CLASS_NAME;
    private static LongCounter logger_exception_log_count;
    private static final AttributeKey<String> UPSTREAM_SAMPLED;
    private static final AttributeKey<String> LOCAL_SAMPLED;
    private static final AttributeKey<String> SAMPLE_FLAG;
    private static LongCounter sampler_sample_count;
    private static LongCounter agent_span_report_result;
    private static LongCounter agent_span_report_bytes;
    private static LongCounter agent_profiling_report_result;
    private static LongCounter agent_profiling_report_bytes;
    private static LongCounter agent_metric_report_result;
    private static LongCounter agent_metric_report_bytes;
    private static LongCounter agent_meta_report_result;
    private static LongCounter agent_meta_report_bytes;
    private static LongCounter meta_data_discarded;
    private static LongCounter agent_custom_extract_count;
    private static LongCounter agent_custom_extract_unknown_exception_count;
    private static LongCounter agent_custom_extract_span_attributes_bytes;
    private static LongCounter agent_custom_error_span_count;
    private static LongCounter trace_span_exceed_limit_count;
    private static LongCounter flow_control_count;
    private static volatile boolean inited;

    public static Meter getSelfMonitorMeter() {
        return GlobalOpenTelemetry.get().meterBuilder("Self-Monitor").build();
    }

    private static synchronized void initSelfMonitorMetric() {
        if (inited) {
            return;
        }
        if (!GlobalOpenTelemetryStatusHolder.isOpenTelemetryInstalled) {
            return;
        }
        instrumenter_start_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_instrumentor_start_count").setUnit("1").setDescription("The minimum number of idle open connections allowed.").build();
        instrumenter_end_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_instrumentor_end_count").setUnit("1").setDescription("The minimum number of idle open connections allowed.").build();
        instrumenter_start_rt = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder(AGENT_START_RT).setUnit("1").setDescription("Agent instrument start method consumed request time.").build();
        instrumenter_end_rt = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder(AGENT_END_RT).setUnit("1").setDescription("Agent instrument end method consumed request time.").build();
        advice_threw_exception_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_advice_threw_exception_count").setUnit("1").setDescription("exception count threw from advice code").build();
        sls_log_report_lines = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_sls_log_report_lines").setUnit("1").setDescription("The number of logs reported to SLS").build();
        sls_log_report_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_sls_log_report_count").setUnit("1").setDescription("The number of logs reported to SLS").build();
        logger_warn_log_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_log_warn_log_count").setUnit("1").setDescription("The number times that fails to report to SLS").build();
        logger_error_log_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_log_error_log_count").setUnit("1").setDescription("The number times that fails to report to SLS").build();
        logger_exception_log_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_log_exception_count").setUnit("1").setDescription("The number times that fails to report to SLS").build();
        sampler_sample_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_sampler_sample_count").setUnit("1").setDescription("The number times that fails to report to SLS").build();
        agent_span_report_result = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_span_report_count").setUnit("1").setDescription("Span report self monitor").build();
        agent_span_report_bytes = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_span_report_bytes").setUnit("1").setDescription("Span report self monitor bytes").build();
        agent_profiling_report_result = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_profiling_report_count").setUnit("1").setDescription("profiling report self monitor").build();
        agent_profiling_report_bytes = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_profiling_report_bytes").setUnit("1").setDescription("profiling report self monitor bytes").build();
        agent_metric_report_result = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_metric_report_count").setUnit("1").setDescription("Metric report self monitor").build();
        agent_metric_report_bytes = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_metric_report_bytes").setUnit("1").setDescription("Metric report self monitor bytes").build();
        agent_meta_report_result = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_meta_report_count").setUnit("1").setDescription("Meta report self monitor").build();
        agent_meta_report_bytes = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_meta_report_bytes").setUnit("1").setDescription("Meta report self monitor bytes").build();
        meta_data_discarded = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_meta_data_discarded").setUnit("1").setDescription("Meta discard self monitor").build();
        agent_custom_extract_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_custom_extract_count").setUnit("1").setDescription("Meta discard self monitor").build();
        agent_custom_extract_span_attributes_bytes = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_custom_extract_span_attributes_bytes").setUnit("1").setDescription("Meta discard self monitor bytes").build();
        agent_custom_error_span_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_custom_error_span_count").setUnit("1").setDescription("Meta discard self monitor").build();
        agent_custom_extract_unknown_exception_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_custom_extract_unknown_exception_count").setUnit("1").setDescription("Meta discard self monitor").build();
        trace_span_exceed_limit_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_agent_limited_span_count").setUnit("1").setDescription("count of span dropped because of limiter").build();
        flow_control_count = SelfMonitorMetrics.getSelfMonitorMeter().counterBuilder("self_monitor_flow_control_requests_count").setUnit("1").setDescription("count of flow control limited").build();
        inited = true;
        selfMonitorTrigger = GlobalInstanceHolder.getInstance(SelfMonitorTrigger.class);
    }

    public static void increaseInstrumenterStartExecutedCount(Attributes attributes) {
        if (SelfMonitorMetrics.enable()) {
            instrumenter_start_count.add(1L, attributes);
        }
    }

    public static void increaseInstrumenterEndResponseTime(Attributes attributes, Long time) {
        if (SelfMonitorMetrics.enable()) {
            instrumenter_end_rt.add(time, attributes);
        }
    }

    public static void increaseInstrumenterStartResponseTime(Attributes attributes, Long time) {
        if (SelfMonitorMetrics.enable()) {
            instrumenter_start_rt.add(time, attributes);
        }
    }

    public static void increaseInstrumenterEndExecutedCount(Attributes attributes) {
        if (SelfMonitorMetrics.enable()) {
            instrumenter_end_count.add(1L, attributes);
        }
    }

    public static void increaseAdviceThrewExceptionCount(Attributes attributes) {
        if (SelfMonitorMetrics.enable()) {
            advice_threw_exception_count.add(1L, attributes);
        }
    }

    public static void increaseReportStatusCountByExportType(Attributes attributes, String exportType, int count, long bytesSize) {
        if (StringUtils.isNullOrEmpty(exportType)) {
            return;
        }
        if (ArmsExporterEnum.META.getType().equals(exportType)) {
            SelfMonitorMetrics.increaseMetaReportStatusCount(attributes, count, bytesSize);
        } else if (ArmsExporterEnum.METRIC.getType().equals(exportType)) {
            SelfMonitorMetrics.increaseMetricReportStatusCount(attributes, count, bytesSize);
        } else if (ArmsExporterEnum.SPAN.getType().equals(exportType)) {
            SelfMonitorMetrics.increaseSpanReportStatusCount(attributes, count, bytesSize);
        }
    }

    private static void increaseMetaReportStatusCount(Attributes attributes, int count, long bytesSize) {
        if (SelfMonitorMetrics.enable()) {
            agent_meta_report_result.add(count, attributes);
            agent_meta_report_bytes.add(bytesSize, attributes);
        }
    }

    private static void increaseMetricReportStatusCount(Attributes attributes, int count, long bytesSize) {
        if (SelfMonitorMetrics.enable()) {
            agent_metric_report_result.add(count, attributes);
            agent_metric_report_bytes.add(bytesSize, attributes);
        }
    }

    public static void increaseProfilingReportBytes(Attributes attributes, long bytesSize) {
        if (SelfMonitorMetrics.enable()) {
            agent_profiling_report_bytes.add(bytesSize, attributes);
        }
    }

    public static void increaseProfilingReportResult(Attributes attributes, int count) {
        if (SelfMonitorMetrics.enable()) {
            agent_profiling_report_result.add(count, attributes);
        }
    }

    private static void increaseSpanReportStatusCount(Attributes attributes, int count, long bytesSize) {
        if (SelfMonitorMetrics.enable()) {
            agent_span_report_result.add(count, attributes);
            agent_span_report_bytes.add(bytesSize, attributes);
        }
    }

    public static void increaseMetaDiscardCount(Attributes attributes, int count) {
        if (SelfMonitorMetrics.enable()) {
            meta_data_discarded.add(count, attributes);
        }
    }

    public static AttributesBuilder getSelfMonitorAttributesBuilder(String userId, String packetType, String hostIp) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        if (!StringUtils.isNullOrEmpty(userId)) {
            attributesBuilder.put(AttributeKey.stringKey("user_id"), userId);
        }
        if (!StringUtils.isNullOrEmpty(packetType)) {
            attributesBuilder.put(AttributeKey.stringKey("type"), packetType);
        }
        if (StringUtils.isNullOrEmpty(hostIp)) {
            attributesBuilder.put(AttributeKey.stringKey("host_ip"), hostIp);
        }
        return attributesBuilder;
    }

    public static void increaseSLSLogReportLines(int count) {
        if (SelfMonitorMetrics.enable()) {
            Attributes attributes = Attributes.of(AttributeKey.booleanKey("report_success"), true);
            sls_log_report_count.add(1L, attributes);
            sls_log_report_lines.add(count, attributes);
        }
    }

    public static void increaseSLSLogReportFailurelines(int count) {
        if (SelfMonitorMetrics.enable()) {
            Attributes attributes = Attributes.of(AttributeKey.booleanKey("report_success"), false);
            sls_log_report_count.add(1L, attributes);
            sls_log_report_lines.add(count, attributes);
        }
    }

    public static void increaseWarnLogCount() {
        if (SelfMonitorMetrics.enable()) {
            logger_warn_log_count.add(1L);
        }
    }

    public static void increaseErrorLogCount() {
        if (SelfMonitorMetrics.enable()) {
            logger_error_log_count.add(1L);
        }
    }

    public static void increaseExceptionCount(String exceptionClassName) {
        if (SelfMonitorMetrics.enable()) {
            logger_exception_log_count.add(1L, Attributes.of(EXCEPTION_CLASS_NAME, exceptionClassName));
        }
    }

    public static void increaseSampleCount(SampleInfoHolder sampleInfoHolder) {
        if (SelfMonitorMetrics.enable()) {
            Boolean upstreamSampled = sampleInfoHolder.getUpstreamSampled();
            Boolean localSampled = sampleInfoHolder.getLocalSampled();
            sampler_sample_count.add(1L, Attributes.of(UPSTREAM_SAMPLED, upstreamSampled == null ? "unset" : upstreamSampled.toString(), LOCAL_SAMPLED, localSampled == null ? "unset" : localSampled.toString(), SAMPLE_FLAG, sampleInfoHolder.getSampleFlag()));
        }
    }

    public static void increaseCustomExtractCount(String recordId, String status, String extractType, String extractSource, int count) {
        if (SelfMonitorMetrics.enable()) {
            agent_custom_extract_count.add(count, Attributes.of(AttributeKey.stringKey("record_id"), recordId, AttributeKey.stringKey("status"), status, AttributeKey.stringKey("extract_type"), extractType, AttributeKey.stringKey("extract_source"), extractSource));
        }
    }

    public static void increaseCustomExtractSpanAttributesBytes(String recordId, long byteSize) {
        if (SelfMonitorMetrics.enable()) {
            agent_custom_extract_span_attributes_bytes.add(byteSize, Attributes.of(AttributeKey.stringKey("record_id"), recordId));
        }
    }

    public static void increaseCustomErrorSpanCount(String recordId, String extractRecordId) {
        if (SelfMonitorMetrics.enable()) {
            agent_custom_error_span_count.add(1L, Attributes.of(AttributeKey.stringKey("record_id"), recordId, AttributeKey.stringKey("extract_record_id"), extractRecordId));
        }
    }

    public static void increaseCustomExtractUnknownExceptionCount(String exceptionSource) {
        if (SelfMonitorMetrics.enable()) {
            agent_custom_extract_unknown_exception_count.add(1L, Attributes.of(AttributeKey.stringKey("excep_src"), exceptionSource));
        }
    }

    public static void increaseLimitedSpanCount(String reason) {
        if (SelfMonitorMetrics.enable()) {
            trace_span_exceed_limit_count.add(1L, Attributes.of(AttributeKey.stringKey("reason"), reason));
        }
    }

    public static void increaseFlowControlLimit() {
        if (SelfMonitorMetrics.enable()) {
            flow_control_count.add(1L);
        }
    }

    public static void registerObservers() {
        Meter meter = SelfMonitorMetrics.getSelfMonitorMeter();
        meter.counterBuilder(AGENT_CONSUMED_CPU_TIME).setDescription("Agent CPU Thread Time Self Monitor").setUnit("ms").buildWithCallback(r -> {
            Thread[] backgroudThreads = new Thread[ArmsThreadFactory.group.activeCount()];
            ArmsThreadFactory.group.enumerate(backgroudThreads);
            ThreadMXBean instance = ManagementFactory.getThreadMXBean();
            long total = 0L;
            for (Thread t : backgroudThreads) {
                if (t == null) continue;
                total += instance.getThreadCpuTime(t.getId());
            }
            r.record(total);
        });
        meter.counterBuilder(AGENT_COU_CORES).setDescription("Agent CPU Cores Self Monitor").setUnit("1").buildWithCallback(r -> r.record(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors()));
        meter.gaugeBuilder(AGENT_CONSUMED_MEMORY).setDescription("Agent Consumed Memory Self Monitor").setUnit("bytes").ofLongs().buildWithCallback(r -> {
            long totalMem = spanMemoryCount.longValue();
            r.record(totalMem);
        });
        meter.gaugeBuilder("self_monitor_alive_instance_count").setDescription("current count of important instance").setUnit("1").ofLongs().buildWithCallback(r -> {
            for (AliveInstanceCounter counter : AliveInstanceCounter.values()) {
                r.record(counter.getAliveInstanceCount(), Attributes.of(AttributeKey.stringKey("instance_type"), counter.getInstanceType()));
            }
        });
    }

    private static boolean enable() {
        if (inited && selfMonitorTrigger != null && selfMonitorTrigger.isSelfMonitorEnable()) {
            return true;
        }
        if (!inited) {
            SelfMonitorMetrics.initSelfMonitorMetric();
        }
        return false;
    }

    public static void setFlow_control_count(LongCounter count) {
        flow_control_count = count;
    }

    public static void setTrace_span_exceed_limit_count(LongCounter count) {
        trace_span_exceed_limit_count = count;
    }

    static {
        spanMemoryCount = new AtomicLong(0L);
        EXCEPTION_CLASS_NAME = AttributeKey.stringKey("exception_class_name");
        UPSTREAM_SAMPLED = AttributeKey.stringKey("upstream_sampled");
        LOCAL_SAMPLED = AttributeKey.stringKey("local_sampled");
        SAMPLE_FLAG = AttributeKey.stringKey("sample_flag");
        inited = false;
    }
}

