/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.credential;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class STSCredential {
    private String ak;
    private String sk;
    private String token;
    private long expireTs;

    public STSCredential() {
    }

    public STSCredential(String ak, String sk, String token, long expireTs) {
        this.ak = ak;
        this.sk = sk;
        this.token = token;
        this.expireTs = expireTs;
    }

    public String getAk() {
        return this.ak;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public String getSk() {
        return this.sk;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getExpireTs() {
        return this.expireTs;
    }

    public ZonedDateTime getExpireZonedDateTime() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.expireTs), ZoneId.systemDefault());
    }

    public void setExpireTs(long expireTs) {
        this.expireTs = expireTs;
    }

    public String toString() {
        return "STSCredential{ak='" + this.ak + '\'' + ", sk='" + this.sk + '\'' + ", token='" + this.token + '\'' + ", expireTs=" + this.expireTs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        STSCredential that = (STSCredential)o;
        return this.expireTs == that.expireTs && Objects.equals(this.ak, that.ak) && Objects.equals(this.sk, that.sk) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.ak, this.sk, this.token, this.expireTs);
    }
}

