/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.TextMatcherTypeEnum;
import java.util.regex.Pattern;

public class TextMatcher {
    public static boolean plainTextMatches(TextMatcherTypeEnum matchType, String pattern, String input) {
        if (matchType == TextMatcherTypeEnum.EQUALS) {
            return StringUtils.equals(input, pattern);
        }
        if (matchType == TextMatcherTypeEnum.START_WITH) {
            return StringUtils.startsWith(input, pattern);
        }
        if (matchType == TextMatcherTypeEnum.END_WITH) {
            return StringUtils.endsWith(input, pattern);
        }
        return false;
    }

    public static boolean regexTextMatches(TextMatcherTypeEnum matchType, Pattern pattern, String input) {
        if (matchType == TextMatcherTypeEnum.REGEX) {
            return StringUtils.regexMatch(input, pattern);
        }
        return false;
    }

    public static boolean numberTextMatches(TextMatcherTypeEnum matchType, String pattern, String input) {
        block5: {
            try {
                Double value = Double.valueOf(input);
                Double patternValue = Double.valueOf(pattern);
                if (matchType == TextMatcherTypeEnum.LARGER) {
                    return patternValue.compareTo(value) < 0;
                }
                if (matchType == TextMatcherTypeEnum.SMALLER) {
                    return patternValue.compareTo(value) > 0;
                }
            }
            catch (NumberFormatException e) {
                if (matchType == TextMatcherTypeEnum.LARGER) {
                    return pattern.compareTo(input) < 0;
                }
                if (matchType != TextMatcherTypeEnum.SMALLER) break block5;
                return pattern.compareTo(input) > 0;
            }
        }
        return false;
    }
}

