/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class SpanUtils {
    private static volatile Field traceFlagFieldInSpan;
    private static volatile Field resourceFieldInSpan;
    private static final PatchLogger logger;

    private static boolean skipInvalidSpan(Span span) {
        return !span.isRecording();
    }

    public static <T> T getAttribute(AttributeKey<T> k, Span span) {
        SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        if (spanReader != null) {
            return spanReader.getAttribute(span, k);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void updateSampleFlag(Span span, TraceFlags traceFlag) {
        if (SpanUtils.skipInvalidSpan(span)) {
            return;
        }
        if (traceFlagFieldInSpan == null) {
            Class<SpanUtils> clazz = SpanUtils.class;
            // MONITORENTER : io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils.class
            if (traceFlagFieldInSpan != null) {
            }
            traceFlagFieldInSpan = span.getSpanContext().getClass().getDeclaredField("traceFlags");
            traceFlagFieldInSpan.setAccessible(true);
        }
        if (traceFlagFieldInSpan == null) return;
        try {
            traceFlagFieldInSpan.set(span.getSpanContext(), traceFlag);
            return;
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "[SpanUtils]updateSampleFlag failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void updateResource(Span span, Object newResource) {
        if (SpanUtils.skipInvalidSpan(span)) {
            return;
        }
        if (resourceFieldInSpan == null) {
            Class<SpanUtils> clazz = SpanUtils.class;
            // MONITORENTER : io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils.class
            if (resourceFieldInSpan != null) {
            }
            resourceFieldInSpan = span.getClass().getDeclaredField("resource");
            resourceFieldInSpan.setAccessible(true);
            Field modifiersField = null;
            String jvmVersion = System.getProperty("java.specification.version");
            if (StringUtils.isNullOrEmpty(jvmVersion) || Float.parseFloat(jvmVersion) < 17.0f) {
                modifiersField = Field.class.getDeclaredField("modifiers");
            } else {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field each : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(each.getName())) continue;
                    modifiersField = each;
                }
            }
            if (modifiersField == null) {
                logger.log(Level.WARNING, "modifiers field not found, BaggageUtil not work");
            }
            modifiersField.setAccessible(true);
            modifiersField.setInt(resourceFieldInSpan, resourceFieldInSpan.getModifiers() & 0xFFFFFFEF);
        }
        if (resourceFieldInSpan == null) return;
        try {
            resourceFieldInSpan.set(span, newResource);
            return;
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "[SpanUtils]updateSampleFlag failed", t);
        }
    }

    static {
        logger = PatchLogger.getLogger(SpanUtils.class.getName());
    }
}

