/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;

public class BaggageUtil {
    private static final PatchLogger logger;
    private static ContextKey<Baggage> BAGGAGE_CONTEXT_KEY;
    private static Field CONTEXT_ENTRY_FIELD;
    private static boolean initializeSuccess;
    private static final int singleBaggageLengthLimit;
    private static final int baggageCountLimit;

    public static boolean putBaggageDirectly(String key, String value) {
        return BaggageUtil.putBaggageDirectly(key, value, null);
    }

    public static boolean putBaggageDirectly(String key, String value, Context context) {
        if (!initializeSuccess) {
            logger.log(Level.FINE, "BaggageUtil is not ready");
            return false;
        }
        if (StringUtils.isNullOrEmpty(key) || StringUtils.isNullOrEmpty(value)) {
            logger.log(Level.FINE, "key or value is empty");
            return false;
        }
        if (key.length() > singleBaggageLengthLimit) {
            key = key.substring(0, singleBaggageLengthLimit);
        }
        if (value.length() > singleBaggageLengthLimit) {
            value = value.substring(0, singleBaggageLengthLimit);
        }
        if (context == null) {
            context = Context.current();
        }
        if (context == Context.root()) {
            logger.log(Level.FINE, "Root context is Immutable");
            return false;
        }
        Baggage baggage = null;
        Object[] entries = null;
        int baggageValueIndex = -1;
        try {
            entries = (Object[])CONTEXT_ENTRY_FIELD.get(context);
            for (int i = 0; i < entries.length; i += 2) {
                if (entries[i] != BAGGAGE_CONTEXT_KEY) continue;
                baggage = (Baggage)entries[i + 1];
                baggageValueIndex = i + 1;
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "Get context entry failed", t);
            return false;
        }
        if (baggage != null) {
            if (baggage.size() >= baggageCountLimit) {
                logger.log(Level.FINE, "baggage size exceed limit " + baggageCountLimit);
                return false;
            }
            entries[baggageValueIndex] = baggage.toBuilder().put(key, value).build();
        } else {
            Object[] newEntries = Arrays.copyOf(entries, entries.length + 2);
            newEntries[entries.length] = BAGGAGE_CONTEXT_KEY;
            newEntries[entries.length + 1] = Baggage.builder().put(key, value).build();
            try {
                CONTEXT_ENTRY_FIELD.set(context, newEntries);
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Update context entry failed", t);
                return false;
            }
        }
        return true;
    }

    public static boolean putMultiBaggage(Map<String, String> map, Context context) {
        if (!initializeSuccess) {
            logger.log(Level.FINE, "BaggageUtil is not ready");
            return false;
        }
        if (context == null) {
            context = Context.current();
        }
        if (context == Context.root()) {
            logger.log(Level.FINE, "Root context is Immutable");
            return false;
        }
        Baggage baggage = null;
        Object[] entries = null;
        int baggageValueIndex = -1;
        try {
            entries = (Object[])CONTEXT_ENTRY_FIELD.get(context);
            for (int i = 0; i < entries.length; i += 2) {
                if (entries[i] != BAGGAGE_CONTEXT_KEY) continue;
                baggage = (Baggage)entries[i + 1];
                baggageValueIndex = i + 1;
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "Get context entry failed", t);
            return false;
        }
        BaggageBuilder builder = Baggage.builder();
        if (baggage != null) {
            if (baggage.size() >= baggageCountLimit) {
                logger.log(Level.FINE, "baggage size exceed limit " + baggageCountLimit);
                return false;
            }
            baggage.forEach((s, baggageEntry) -> builder.put((String)s, baggageEntry.getValue()));
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            entries[baggageValueIndex] = builder.build();
        } else {
            Object[] newEntries = Arrays.copyOf(entries, entries.length + 2);
            newEntries[entries.length] = BAGGAGE_CONTEXT_KEY;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            newEntries[entries.length + 1] = builder.build();
            try {
                CONTEXT_ENTRY_FIELD.set(context, newEntries);
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Update context entry failed", t);
                return false;
            }
        }
        return true;
    }

    public static boolean putMultiBaggage(String[] strings) {
        return BaggageUtil.putMultiBaggage(strings, null);
    }

    public static boolean putMultiBaggage(String[] strings, Context context) {
        if (!initializeSuccess) {
            logger.log(Level.FINE, "BaggageUtil is not ready");
            return false;
        }
        if (context == null) {
            context = Context.current();
        }
        if (context == Context.root()) {
            logger.log(Level.FINE, "Root context is Immutable");
            return false;
        }
        Baggage baggage = null;
        Object[] entries = null;
        int baggageValueIndex = -1;
        try {
            entries = (Object[])CONTEXT_ENTRY_FIELD.get(context);
            for (int i = 0; i < entries.length; i += 2) {
                if (entries[i] != BAGGAGE_CONTEXT_KEY) continue;
                baggage = (Baggage)entries[i + 1];
                baggageValueIndex = i + 1;
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "Get context entry failed", t);
            return false;
        }
        BaggageBuilder builder = Baggage.builder();
        if (baggage != null) {
            if (baggage.size() >= baggageCountLimit) {
                logger.log(Level.FINE, "baggage size exceed limit " + baggageCountLimit);
                return false;
            }
            baggage.forEach((s, baggageEntry) -> builder.put((String)s, baggageEntry.getValue()));
            for (int i = 0; i < strings.length; i += 2) {
                if (StringUtils.isNullOrEmpty(strings[i]) || StringUtils.isNullOrEmpty(strings[i + 1])) {
                    logger.log(Level.FINE, "key or value is empty");
                    return false;
                }
                builder.put(strings[i].length() > singleBaggageLengthLimit ? strings[i].substring(0, singleBaggageLengthLimit) : strings[i], strings[i + 1].length() > singleBaggageLengthLimit ? strings[i + 1].substring(0, singleBaggageLengthLimit) : strings[i + 1]);
            }
            entries[baggageValueIndex] = builder.build();
        } else {
            Object[] newEntries = Arrays.copyOf(entries, entries.length + 2);
            newEntries[entries.length] = BAGGAGE_CONTEXT_KEY;
            for (int i = 0; i < strings.length; i += 2) {
                if (StringUtils.isNullOrEmpty(strings[i]) || StringUtils.isNullOrEmpty(strings[i + 1])) {
                    logger.log(Level.FINE, "key or value is empty");
                    return false;
                }
                builder.put(strings[i].length() > singleBaggageLengthLimit ? strings[i].substring(0, singleBaggageLengthLimit) : strings[i], strings[i + 1].length() > singleBaggageLengthLimit ? strings[i + 1].substring(0, singleBaggageLengthLimit) : strings[i + 1]);
            }
            newEntries[entries.length + 1] = builder.build();
            try {
                CONTEXT_ENTRY_FIELD.set(context, newEntries);
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Update context entry failed", t);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDirectly(String key, Context context) {
        if (!initializeSuccess) {
            logger.log(Level.FINE, "BaggageUtil is not ready");
            return false;
        }
        if (context == null) {
            context = Context.current();
        }
        if (context == Context.root()) {
            logger.log(Level.FINE, "Root context is Immutable");
            return false;
        }
        Baggage baggage = null;
        Object[] entries = null;
        int baggageValueIndex = -1;
        try {
            entries = (Object[])CONTEXT_ENTRY_FIELD.get(context);
            for (int i = 0; i < entries.length; i += 2) {
                if (entries[i] != BAGGAGE_CONTEXT_KEY) continue;
                baggage = (Baggage)entries[i + 1];
                baggageValueIndex = i + 1;
            }
        }
        catch (Throwable t) {
            logger.log(Level.FINE, "Get context entry failed", t);
            return false;
        }
        BaggageBuilder builder = Baggage.builder();
        boolean keyExist = false;
        if (baggage != null) {
            baggage.forEach((s, baggageEntry) -> {
                if (!s.equals(key)) {
                    builder.put((String)s, baggageEntry.getValue());
                }
            });
            Baggage newBaggage = builder.build();
            if (baggage.size() != newBaggage.size()) {
                keyExist = true;
            }
            entries[baggageValueIndex] = newBaggage;
        }
        return keyExist;
    }

    static {
        Field keyField2;
        logger = PatchLogger.getLogger(BaggageUtil.class.getName());
        initializeSuccess = false;
        singleBaggageLengthLimit = ConfigPropertiesUtil.getInt("profiler.armssdk.baggageLengthLimit", 512);
        baggageCountLimit = ConfigPropertiesUtil.getInt("profiler.armssdk.baggageCountLimit", 20);
        try {
            keyField2 = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageContextKey").getDeclaredField("KEY");
            keyField2.setAccessible(true);
            BAGGAGE_CONTEXT_KEY = (ContextKey)keyField2.get(null);
            CONTEXT_ENTRY_FIELD = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ArrayBasedContext").getDeclaredField("entries");
            initializeSuccess = true;
        }
        catch (Throwable keyField2) {
            // empty catch block
        }
        if (!initializeSuccess) {
            try {
                keyField2 = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageContextKey").getDeclaredField("KEY");
                keyField2.setAccessible(true);
                BAGGAGE_CONTEXT_KEY = (ContextKey)keyField2.get(null);
                CONTEXT_ENTRY_FIELD = Class.forName("io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ArrayBasedContext").getDeclaredField("entries");
                initializeSuccess = true;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Init BaggageUtil static field failed", t);
            }
        }
        if (initializeSuccess) {
            try {
                CONTEXT_ENTRY_FIELD.setAccessible(true);
                Field modifiersField = null;
                String jvmVersion = System.getProperty("java.specification.version");
                if (StringUtils.isNullOrEmpty(jvmVersion) || Float.parseFloat(jvmVersion) < 17.0f) {
                    modifiersField = Field.class.getDeclaredField("modifiers");
                } else {
                    Field[] fields;
                    Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                    getDeclaredFields0.setAccessible(true);
                    for (Field each : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                        if (!"modifiers".equals(each.getName())) continue;
                        modifiersField = each;
                    }
                }
                if (modifiersField == null) {
                    logger.log(Level.WARNING, "modifiers field not found, BaggageUtil not work");
                } else {
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(CONTEXT_ENTRY_FIELD, CONTEXT_ENTRY_FIELD.getModifiers() & 0xFFFFFFEF);
                }
            }
            catch (Throwable t) {
                initializeSuccess = false;
                logger.log(Level.WARNING, "Update baggageUtil static field modifier failed", t);
            }
        }
    }
}

