/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.AutoInstanceRegister;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class GlobalInstanceHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(GlobalInstanceHolder.class.getName());
    private static final Map<Class<?>, Object> instanceHolder = new ConcurrentHashMap();

    public static void registerInstance(Object instance) {
        for (Class<?> clazz : instance.getClass().getInterfaces()) {
            if (clazz.equals(AutoInstanceRegister.class)) continue;
            instanceHolder.put(clazz, instance);
        }
    }

    public static <T> T getInstance(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("params clazz is null");
        }
        if (!instanceHolder.containsKey(clazz)) {
            logger.log(Level.WARNING, "Failed to get clazz " + clazz.getName() + " from GlobalInstanceHolder");
            return null;
        }
        return (T)instanceHolder.get(clazz);
    }
}

