/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.ConfigInitializer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalConfigInstanceHolder {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(GlobalConfigInstanceHolder.class.getName());
    private static final Map<Class<?>, List<Object>> instanceHolder = new ConcurrentHashMap();
    private static ConfigInitializer CONFIG_INITIALIZER;

    public static void registerInstance(Object instance) {
        try {
            if (!instanceHolder.containsKey(instance.getClass())) {
                ArrayList<Object> instances = new ArrayList<Object>();
                instances.add(instance);
                instanceHolder.put(instance.getClass(), instances);
            } else {
                instanceHolder.get(instance.getClass()).add(instance);
            }
            if (CONFIG_INITIALIZER != null) {
                CONFIG_INITIALIZER.initConfig(instance);
            }
        }
        catch (Throwable t) {
            logger.warn("Failed to register instance", t);
        }
    }

    public static void registerConfigInitializer(ConfigInitializer configInitializer) {
        if (configInitializer == null) {
            return;
        }
        CONFIG_INITIALIZER = configInitializer;
        CONFIG_INITIALIZER.updateConfigPeriod(60L);
    }

    public static ConfigInitializer getConfigInitializer() {
        return CONFIG_INITIALIZER;
    }

    public static Collection<List<Object>> listInstances() {
        return instanceHolder.values();
    }
}

