/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.AliveInstanceCounter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.flowcontrol.ArmsFlowControlService;

public enum SimpleSpanLimiter {
    INSTANCE;

    private ArmsFlowControlService adaptor;
    private final AliveInstanceCounter counter = AliveInstanceCounter.SPAN_COUNTER;

    public void setAdaptor(ArmsFlowControlService adaptor) {
        this.adaptor = adaptor;
    }

    public boolean canPassCheck() {
        if (this.isSpanControlEnabled()) {
            if (this.counter.getAliveInstanceCount() * SelfMonitorMetrics.SELF_MONITOR_SAMPLE_RATE < this.getSpanControlThreshold()) {
                return true;
            }
            SelfMonitorMetrics.increaseLimitedSpanCount("exceed-span-total-alive-limit");
            return false;
        }
        return true;
    }

    private boolean isSpanControlEnabled() {
        return this.adaptor != null && this.adaptor.isSpanControlEnabled();
    }

    private long getSpanControlThreshold() {
        return this.adaptor == null ? 50000L : this.adaptor.getSpanControlThreshold();
    }
}

