/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.Cleaner;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.PhantomCleanable;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public final class CleanerImpl
implements Runnable {
    private static Function<Cleaner, CleanerImpl> cleanerImplAccess = null;
    final PhantomCleanable<?> phantomCleanableList;
    final ReferenceQueue<Object> queue = new ReferenceQueue();

    public CleanerImpl() {
        this.phantomCleanableList = new PhantomCleanableRef();
    }

    public void start(Cleaner cleaner, ThreadFactory threadFactory) {
        new CleanerCleanable(cleaner);
        Thread thread = threadFactory.newThread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (!this.phantomCleanableList.isListEmpty()) {
            try {
                Cleaner.Cleanable ref = (Cleaner.Cleanable)((Object)this.queue.remove(60000L));
                if (ref == null) continue;
                ref.clean();
            }
            catch (Throwable throwable) {}
        }
    }

    public static final class PhantomCleanableRef
    extends PhantomCleanable<Object> {
        private final Runnable action;

        public PhantomCleanableRef(Object obj, Cleaner cleaner, Runnable action) {
            super(obj, cleaner);
            this.action = action;
        }

        PhantomCleanableRef() {
            this.action = null;
        }

        @Override
        protected void performCleanup() {
            if (this.action != null) {
                this.action.run();
            }
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("get");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }
    }

    static final class CleanerCleanable
    extends PhantomCleanable<Cleaner> {
        CleanerCleanable(Cleaner cleaner) {
            super(cleaner, cleaner);
        }

        @Override
        protected void performCleanup() {
        }
    }
}

