/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.Cleaner;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public enum AliveInstanceCounter {
    SPAN_COUNTER("span");

    private static final Cleaner cleaner;
    private final String instanceType;
    private final AtomicLong instanceCounter;

    private AliveInstanceCounter(String instanceType) {
        this.instanceType = instanceType;
        this.instanceCounter = new AtomicLong();
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public long getAliveInstanceCount() {
        return this.instanceCounter.get();
    }

    public long incrementAndGet(Object instance) {
        cleaner.register(instance, this.instanceCounter::decrementAndGet);
        return this.instanceCounter.incrementAndGet();
    }

    static {
        cleaner = Cleaner.create(new ArmsThreadFactory("alive-instance-counter-thread", true));
    }
}

