/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.mse;

import io.opentelemetry.javaagent.bootstrap.mse.AdditionalInfo;
import io.opentelemetry.javaagent.bootstrap.mse.AgentStartupStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MseStartupReporter {
    private static String regionId = null;
    private static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "MseStartupReporter");
        thread.setDaemon(true);
        return thread;
    });
    private static String mseHost;
    private static String armsAppId;
    private static String mseAppId;
    private static String mseLicenseKey;
    private static boolean agentDebugEnabled;

    public static void reportThrowableIfNecessary(Throwable failedThrowable, String failedMessage) {
        try {
            if (MseStartupReporter.isCloudProductMseEnable()) {
                AdditionalInfo additionalInfo = new AdditionalInfo();
                if (failedThrowable != null) {
                    additionalInfo.bootstrapStatus = "failed";
                    StringWriter errors = new StringWriter();
                    failedThrowable.printStackTrace(new PrintWriter(errors));
                    additionalInfo.failedMessage = failedMessage + errors;
                } else if (failedMessage != null && !failedMessage.isEmpty()) {
                    additionalInfo.bootstrapStatus = "success";
                    additionalInfo.failedMessage = failedMessage;
                } else {
                    return;
                }
                MseStartupReporter.reportAgentAdditionalInfo(additionalInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void reportAgentAdditionalInfo(AdditionalInfo additionalInfo) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable()) {
                    AgentStartupStatus agentStartupStatus = MseStartupReporter.buildAgentStartupStatus(additionalInfo);
                    MseStartupReporter.doReport(agentStartupStatus);
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    private static boolean isCloudProductMseEnable() {
        return mseLicenseKey != null && !mseLicenseKey.isEmpty();
    }

    public static void reportAgentAdditionalInfoAsync(AdditionalInfo additionalInfo) {
        block3: {
            try {
                if (MseStartupReporter.isCloudProductMseEnable()) {
                    executor.schedule(() -> {
                        AgentStartupStatus agentStartupStatus = MseStartupReporter.buildAgentStartupStatus(additionalInfo);
                        MseStartupReporter.doReport(agentStartupStatus);
                    }, 60L, TimeUnit.SECONDS);
                }
            }
            catch (Throwable e) {
                if (!agentDebugEnabled) break block3;
                System.err.println("[aliyun-java-agent][mse]reportAgentAdditionalInfo error:" + e.getMessage());
            }
        }
    }

    private static AgentStartupStatus buildAgentStartupStatus(AdditionalInfo additionalInfo) {
        AgentStartupStatus res = new AgentStartupStatus();
        res.agentCommit = "c89a699";
        res.agentBranch = "4.2.1-llm";
        res.armsAppId = armsAppId;
        res.mseAppId = mseAppId;
        res.regionId = regionId;
        res.serverIp = MseStartupReporter.getIp();
        res.additionalInfo = additionalInfo;
        return res;
    }

    private static String getIp() {
        StringBuilder ip = new StringBuilder();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                if (n.isLoopback()) continue;
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (i.isAnyLocalAddress()) continue;
                    if (ip.length() > 0) {
                        ip.append(",");
                    }
                    ip.append(i.getHostAddress());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ip.toString();
    }

    private static void doReport(AgentStartupStatus agentStartupStatus) {
        block6: {
            boolean reportSuccessful;
            block5: {
                reportSuccessful = false;
                try {
                    MseStartupReporter.report0(agentStartupStatus, mseHost);
                    reportSuccessful = true;
                }
                catch (Throwable e) {
                    reportSuccessful = false;
                    if (!agentDebugEnabled) break block5;
                    System.err.println("[aliyun-java-agent][mse]report0 error:" + e.getMessage());
                }
            }
            if (!reportSuccessful) {
                try {
                    mseHost = "mse." + regionId + ".aliyuncs.com";
                    MseStartupReporter.report0(agentStartupStatus, mseHost);
                    reportSuccessful = true;
                }
                catch (Throwable e) {
                    reportSuccessful = false;
                    if (!agentDebugEnabled) break block6;
                    System.err.println("[aliyun-java-agent][mse]report1 error:" + e.getMessage());
                }
            }
        }
    }

    private static void report0(AgentStartupStatus agentStartupStatus, String mseHost) throws IOException {
        Instant now = Instant.now();
        String datetime = DateTimeFormatter.ISO_INSTANT.format(now);
        StringBuilder urlString = new StringBuilder("http://" + mseHost + "/?");
        urlString.append(URLEncoder.encode("Action", "UTF-8")).append("=").append(URLEncoder.encode("ReportAgentStartupStatus", "UTF-8")).append("&");
        urlString.append(URLEncoder.encode("Version", "UTF-8")).append("=").append(URLEncoder.encode("2019-05-31", "UTF-8")).append("&");
        urlString.append(URLEncoder.encode("Timestamp", "UTF-8")).append("=").append(URLEncoder.encode(datetime, "UTF-8")).append("&");
        urlString.append(URLEncoder.encode("LicenseKey", "UTF-8")).append("=").append(URLEncoder.encode(mseLicenseKey, "UTF-8")).append("&");
        URL url = new URL(urlString.toString());
        HttpURLConnection con = MseStartupReporter.openConnection(url);
        con.setRequestMethod("POST");
        String mseDebugHost = System.getenv("MSE_DEBUG_HOST");
        if (mseDebugHost != null && !mseDebugHost.isEmpty()) {
            con.setRequestProperty("x-acs-debug-http-host", mseDebugHost);
        }
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("x-acs-action", "ReportAgentStartupStatus");
        con.setRequestProperty("x-mse-AppId", mseAppId);
        con.setRequestProperty("x-mse-Region", regionId);
        con.setConnectTimeout(100);
        con.setReadTimeout(500);
        con.setDoOutput(true);
        String jsonInputString = agentStartupStatus.toJson();
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int status = con.getResponseCode();
        String reqId = con.getHeaderField("x-acs-request-id");
        if (agentDebugEnabled) {
            System.err.println("[aliyun-java-agent][mse]MseStartupReporter report0 error," + status + ",reqId=" + reqId);
        }
    }

    static HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        return con;
    }

    static {
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getProperty("aliyun.javaagent.regionId");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getProperty("mse.regionId");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getProperty("oneagent.region");
        }
        if (regionId == null || regionId.isEmpty()) {
            regionId = "cn-zhangjiakou";
        }
        mseHost = null;
        mseHost = "mse-vpc." + regionId + ".aliyuncs.com";
        armsAppId = "";
        armsAppId = System.getProperty("arms.appId");
        mseAppId = "";
        mseAppId = System.getProperty("mse.appId");
        mseLicenseKey = "";
        mseLicenseKey = System.getProperty("mse.licenseKey");
        agentDebugEnabled = false;
        try {
            agentDebugEnabled = Boolean.parseBoolean(System.getProperty("otel.javaagent.debug"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

