/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.bootstrap.internal.DeprecatedConfigProperties;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CommonConfig {
    private static final CommonConfig instance = new CommonConfig(InstrumentationConfig.get());
    private final Map<String, String> peerServiceMapping;
    private final List<String> clientRequestHeaders;
    private final List<String> clientResponseHeaders;
    private final List<String> serverRequestHeaders;
    private final List<String> serverResponseHeaders;
    private final boolean statementSanitizationEnabled;

    public static CommonConfig get() {
        return instance;
    }

    CommonConfig(InstrumentationConfig config) {
        this.peerServiceMapping = config.getMap("otel.instrumentation.common.peer-service-mapping", Collections.emptyMap());
        this.clientRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.request", "otel.instrumentation.http.client.capture-request-headers");
        this.clientResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.response", "otel.instrumentation.http.client.capture-response-headers");
        this.serverRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.request", "otel.instrumentation.http.server.capture-request-headers");
        this.serverResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.response", "otel.instrumentation.http.server.capture-response-headers");
        this.statementSanitizationEnabled = config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true);
    }

    public Map<String, String> getPeerServiceMapping() {
        return this.peerServiceMapping;
    }

    public List<String> getClientRequestHeaders() {
        return this.clientRequestHeaders;
    }

    public List<String> getClientResponseHeaders() {
        return this.clientResponseHeaders;
    }

    public List<String> getServerRequestHeaders() {
        return this.serverRequestHeaders;
    }

    public List<String> getServerResponseHeaders() {
        return this.serverResponseHeaders;
    }

    public boolean isStatementSanitizationEnabled() {
        return this.statementSanitizationEnabled;
    }
}

