/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.OpenTelemetryAgent;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.credential.STSCredential;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class CrashDataCollector {
    private static final int CHUNK_SIZE = 524288;
    public static boolean isSetCrashScript = false;
    private static final String LOCAL_CACHE_FILENAME = ".running_status";

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = OpenTelemetryAgent.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        URL url = classLoader.getResource(OpenTelemetryAgent.class.getName().replace('.', '/') + ".class");
        String resourcePath = url.toURI().getSchemeSpecificPart();
        int protocolSeparatorIndex = resourcePath.indexOf(":");
        int resourceSeparatorIndex = resourcePath.indexOf("!/");
        if (protocolSeparatorIndex == -1 || resourceSeparatorIndex == -1) {
            throw new IllegalStateException("could not get agent location from url " + url);
        }
        String agentPath = resourcePath.substring(protocolSeparatorIndex + 1, resourceSeparatorIndex);
        File javaagentFile = new File(agentPath);
        AgentClassLoader agentClassLoader = new AgentClassLoader(javaagentFile, "inst", false, ClassLoader.getSystemClassLoader());
        String profilingStart = CrashDataCollector.getProfilerRelatedInfo("ProfilingStart", javaagentFile.getAbsolutePath());
        Class<?> agentInitializer = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
        Method method = agentInitializer.getMethod("doSendAppCrashEvent", String.class, String.class);
        method.setAccessible(true);
        String eventId = UUID.randomUUID().toString();
        method.invoke(null, profilingStart, eventId);
        Optional<STSCredential> localCredential = CrashDataCollector.getSTSCredential(javaagentFile.getAbsolutePath(), agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.aliyun.common.STSCredentialSupplierImpl$CredentialHolder"));
        if (!localCredential.isPresent()) {
            System.out.println("Failed to collect the crash log with ARMS. It appears that a connection to the ARMS server could not be established. Please check your local network settings.");
            return;
        }
        try {
            CrashDataCollector.readLogAndUpload(agentClassLoader, localCredential, eventId);
        }
        catch (Exception e) {
            System.err.println("Failed to collect crash log, error=" + e.getMessage());
        }
    }

    public static Optional<STSCredential> getSTSCredential(String absolutePath, Class<?> credentialQueryImpl) {
        Optional localCredential = CrashDataCollector.getLocalCredential(absolutePath);
        CrashDataCollector.cleanLocalFile(absolutePath);
        if (!localCredential.isPresent() || System.currentTimeMillis() > localCredential.get().getExpireTs()) {
            try {
                Method getSTSCredentialFromGraphGateway = credentialQueryImpl.getMethod("getSTSCredentialFromGraphGateway", new Class[0]);
                getSTSCredentialFromGraphGateway.setAccessible(true);
                localCredential = (Optional)getSTSCredentialFromGraphGateway.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return localCredential;
    }

    private static void readLogAndUpload(AgentClassLoader agentClassLoader, Optional<STSCredential> stsCredential, String eventId) throws Exception {
        String regionId = ConfigPropertiesUtil.getString("aliyun.javaagent.regionId");
        Class<?> slsServiceImpl = agentClassLoader.loadClass("io.opentelemetry.javaagent.logging.arms.sls.SLSWriteServiceImpl");
        Constructor<?> constructor = slsServiceImpl.getConstructor(String.class, STSCredential.class);
        Object serviceImpl = constructor.newInstance(regionId, stsCredential.get());
        Method reportLog = slsServiceImpl.getMethod("reportCrashLog", String.class, String.class);
        reportLog.setAccessible(true);
        String crashLogPath = ConfigPropertiesUtil.getString("arms.crashlog.path");
        File logFile = new File(crashLogPath);
        if (!logFile.exists() || !logFile.isFile()) {
            throw new IllegalArgumentException("-Darms.crashlog.path is not a valid filename: " + crashLogPath);
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(logFile));){
            int bytesRead;
            byte[] buffer = new byte[524288];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                String content = new String(buffer, 0, bytesRead, StandardCharsets.UTF_8);
                reportLog.invoke(serviceImpl, content, eventId);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read crash log, -Darms.crashlog.path=" + crashLogPath);
        }
    }

    public static boolean updateProfilerRelatedInfo(String key, Object value, String absolutePath) {
        if (!isSetCrashScript) {
            return false;
        }
        try {
            String agentHome = CrashDataCollector.getAgentDir(absolutePath);
            String filePath = Paths.get(agentHome, LOCAL_CACHE_FILENAME).toString();
            Path path = Paths.get(filePath, new String[0]);
            Path parentDir = path.getParent();
            if (parentDir != null && Files.notExists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            StringBuilder updatedLines = new StringBuilder();
            boolean isUpdate = false;
            if (!Files.notExists(path, new LinkOption[0])) {
                List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
                for (String line : lines) {
                    if (line.startsWith(key + "=")) {
                        line = key + "=" + value;
                        isUpdate = true;
                    }
                    updatedLines.append(line + "\n");
                }
            }
            if (!isUpdate) {
                updatedLines.append(key + "=" + value + "\n");
            }
            Files.write(path, updatedLines.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Optional<STSCredential> getLocalCredential(String absolutePath) {
        String tempStsCredential = CrashDataCollector.getProfilerRelatedInfo("tempStsCredential", absolutePath);
        return CrashDataCollector.parseSTSCredential(tempStsCredential);
    }

    public static Optional<STSCredential> parseSTSCredential(String jsonString) {
        if (StringUtils.isNullOrEmpty(jsonString)) {
            return Optional.empty();
        }
        String ak = null;
        String sk = null;
        String token = null;
        long expireTs = 0L;
        try {
            String[] pairs;
            jsonString = jsonString.replace("STSCredential{", "").replace("}", "").trim();
            block14: for (String pair : pairs = jsonString.split(",\\s*")) {
                String[] keyValue = pair.split("=");
                String key = keyValue.length > 0 ? keyValue[0].trim() : null;
                String value = "";
                value = keyValue.length == 2 ? keyValue[1].trim().replace("'", "") : pair.substring(pair.indexOf("'") + 1, pair.lastIndexOf("'"));
                switch (key) {
                    case "ak": {
                        ak = value;
                        continue block14;
                    }
                    case "sk": {
                        sk = value;
                        continue block14;
                    }
                    case "token": {
                        token = value;
                        continue block14;
                    }
                    case "expireTs": {
                        expireTs = Long.parseLong(value);
                    }
                }
            }
            return Optional.of(new STSCredential(ak, sk, token, expireTs));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static String getProfilerRelatedInfo(String key, String absolutePath) {
        try {
            String agentHome = CrashDataCollector.getAgentDir(absolutePath);
            String filePath = Paths.get(agentHome, LOCAL_CACHE_FILENAME).toString();
            Path path = Paths.get(filePath, new String[0]);
            if (path != null && Files.notExists(path, new LinkOption[0])) {
                return "";
            }
            List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]));
            for (String line : lines) {
                String prefix;
                if (!line.startsWith(prefix = key + "=")) continue;
                return line.substring(prefix.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanLocalFile(String absolutePath) {
        File file = null;
        try {
            String agentHome = CrashDataCollector.getAgentDir(absolutePath);
            String filePath = Paths.get(agentHome, LOCAL_CACHE_FILENAME).toString();
            file = new File(filePath);
        }
        catch (Exception exception) {
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    private static String getAgentDir(String absolutePath) {
        String[] split = absolutePath.split("[/\\\\]");
        if (split[split.length - 1].contains(".jar")) {
            int lastSlash = absolutePath.lastIndexOf(47);
            int lastBackslash = absolutePath.lastIndexOf(92);
            int lastIndex = Math.max(lastSlash, lastBackslash);
            return absolutePath.substring(0, lastIndex + 1);
        }
        return absolutePath;
    }
}

