/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class AliYunJavaAgentInit {
    public static boolean shouldIgnore() {
        try {
            String name;
            String pid;
            Path p;
            Path execPath;
            boolean isJava;
            String forceAttach = System.getProperty("arms.attach.force");
            if ("true".equalsIgnoreCase(forceAttach)) {
                return false;
            }
            String jamHome = System.getProperty("JAM_HOME");
            if ("/opt/jam".equals(jamHome)) {
                return true;
            }
            String cps = System.getProperty("java.class.path");
            if (cps != null) {
                String[] cpItem = cps.split(File.pathSeparator);
                if (cpItem.length == 2 && (cpItem[0].endsWith("arthas-boot.jar") || cpItem[1].endsWith("arthas-boot.jar"))) {
                    return true;
                }
                if (cpItem.length == 1) {
                    String[] parts = cpItem[0].split("/");
                    Pattern pattern = Pattern.compile("byteBuddyAttacher.*\\.jar");
                    if (parts.length >= 1 && pattern.matcher(parts[parts.length - 1]).matches()) {
                        return true;
                    }
                }
            }
            if (!(isJava = (execPath = Files.readSymbolicLink(p = Paths.get(String.format("/proc/%s/exe", pid = (name = ManagementFactory.getRuntimeMXBean().getName()).split("@")[0]), new String[0]))).endsWith("java"))) {
                return true;
            }
            File cmdlineFile = new File(String.format("/proc/%s/cmdline", pid));
            if (!cmdlineFile.exists()) break block11;
            List<String> lines = AliYunJavaAgentInit.readLines(cmdlineFile);
            if (lines.size() <= 0) break block12;
            String[] items = lines.get(0).split("\u0000");
            if (items.length < 2) break block13;
            if (!items[0].endsWith("java")) break block14;
            if (items[1].contains("-version") || items[items.length - 1].endsWith("CrashDataCollector")) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block11: {
                block12: {
                    block13: {
                        block14: {
                        }
                    }
                }
            }
        }
    }

    public static boolean checkMemoryLimit() {
        long max = Runtime.getRuntime().maxMemory();
        long minimalMemoryRequired = 0x10000000L;
        String minimal = null;
        try {
            minimal = ConfigPropertiesUtil.getString("aliyun.java.agent.minimal.memory", "268435456");
            minimalMemoryRequired = Long.parseLong(minimal);
        }
        catch (Exception e) {
            System.out.println("Invalid aliyun.java.agent.minimal.memory value:" + minimal);
            return false;
        }
        if (max < minimalMemoryRequired) {
            System.out.println("Aliyun Java Agent requires minimal memory of 256M, the current memory size is: " + max + ", aliyun java agent won't start. You can adjust it with -Daliyun.java.agent.minimal.memory=268435456");
            return false;
        }
        return true;
    }

    public static List<String> readLines(File file) throws IOException {
        BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }
}

