/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent;

import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.AliYunJavaAgentInit;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.bootstrap.JavaagentFileHolder;
import io.opentelemetry.javaagent.bootstrap.mse.MseStartupReporter;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class OpenTelemetryAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.startAgent(inst, true);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.startAgent(inst, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAgent(Instrumentation inst, boolean fromPremain) {
        String failedMessage;
        Throwable failedThrowable;
        block5: {
            failedThrowable = null;
            failedMessage = "";
            System.setProperty("ALIYUN_JAVA_AGENT_START_TIMESTAMP_IN_MS", String.valueOf(System.currentTimeMillis()));
            if (!AliYunJavaAgentInit.shouldIgnore()) break block5;
            MseStartupReporter.reportThrowableIfNecessary(failedThrowable, failedMessage);
            return;
        }
        try {
            File javaagentFile = OpenTelemetryAgent.installBootstrapJar(inst);
            InstrumentationHolder.setInstrumentation(inst);
            JavaagentFileHolder.setJavaagentFile(javaagentFile);
            AgentInitializer.initialize(inst, javaagentFile, fromPremain);
        }
        catch (Throwable ex) {
            try {
                System.err.println("ERROR " + OpenTelemetryAgent.class.getName());
                ex.printStackTrace();
                failedThrowable = ex;
            }
            catch (Throwable throwable) {
                MseStartupReporter.reportThrowableIfNecessary(failedThrowable, failedMessage);
                throw throwable;
            }
            MseStartupReporter.reportThrowableIfNecessary(failedThrowable, failedMessage);
        }
        MseStartupReporter.reportThrowableIfNecessary(failedThrowable, failedMessage);
    }

    private static synchronized File installBootstrapJar(Instrumentation inst) throws IOException, URISyntaxException {
        URL url;
        ClassLoader classLoader = OpenTelemetryAgent.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((url = classLoader.getResource(OpenTelemetryAgent.class.getName().replace('.', '/') + ".class")) == null || !"jar".equals(url.getProtocol())) {
            throw new IllegalStateException("could not get agent jar location from url " + url);
        }
        String resourcePath = url.toURI().getSchemeSpecificPart();
        int protocolSeparatorIndex = resourcePath.indexOf(":");
        int resourceSeparatorIndex = resourcePath.indexOf("!/");
        if (protocolSeparatorIndex == -1 || resourceSeparatorIndex == -1) {
            throw new IllegalStateException("could not get agent location from url " + url);
        }
        String agentPath = resourcePath.substring(protocolSeparatorIndex + 1, resourceSeparatorIndex);
        File javaagentFile = new File(agentPath);
        if (!javaagentFile.isFile()) {
            throw new IllegalStateException("agent jar location doesn't appear to be a file: " + javaagentFile.getAbsolutePath());
        }
        JarFile agentJar = new JarFile(javaagentFile, false);
        OpenTelemetryAgent.verifyJarManifestMainClassIsThis(javaagentFile, agentJar);
        inst.appendToBootstrapClassLoaderSearch(agentJar);
        return javaagentFile;
    }

    private static void verifyJarManifestMainClassIsThis(File jarFile, JarFile agentJar) throws IOException {
        Manifest manifest = agentJar.getManifest();
        if (manifest.getMainAttributes().getValue("Premain-Class") == null) {
            throw new IllegalStateException("The agent was not installed, because the agent was found in '" + jarFile + "', which doesn't contain a Premain-Class manifest attribute. Make sure that you haven't included the agent jar file inside of an application uber jar.");
        }
    }

    public static void main(String ... args) {
        try {
            System.out.println(OpenTelemetryAgent.class.getPackage().getImplementationVersion());
        }
        catch (RuntimeException e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    private OpenTelemetryAgent() {
    }
}

