/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.example.stock.service;

import com.alibaba.cloud.ai.example.stock.service.StockService;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
public class StockService {
    private static final Logger logger = LoggerFactory.getLogger(StockService.class);
    private static final String BASE_URL = "https://push2.eastmoney.com/api/qt/stock/get";
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final RestClient restClient = RestClient.builder().baseUrl("https://push2.eastmoney.com/api/qt/stock/get").defaultHeader("Accept", new String[]{"application/json"}).build();

    @Tool(name="getStockInfo", description="Get real-time stock information for the specified stock code")
    public StockInfo getStockInfo(String stockCode) {
        try {
            if (!stockCode.matches("^[0-9]{6}$")) {
                throw new IllegalArgumentException("Stock code must be 6 digits");
            }
            logger.info("Fetching stock information for {}", (Object)stockCode);
            String secid = stockCode.startsWith("6") ? "1." + stockCode : "0." + stockCode;
            String response = (String)this.restClient.get().uri(uriBuilder -> uriBuilder.queryParam("secid", new Object[]{secid}).queryParam("fields", new Object[]{"f43,f44,f45,f46,f47,f48,f57,f58"}).build(new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().body(String.class);
            logger.info("Raw response: {}", (Object)response);
            JsonNode root = objectMapper.readTree(response);
            JsonNode data = root.path("data");
            if (data.isMissingNode()) {
                logger.warn("No stock data found");
                throw new IllegalArgumentException("No information found for stock code " + stockCode);
            }
            StockData stockData = (StockData)objectMapper.treeToValue((TreeNode)data, StockData.class);
            logger.info("Parsed data: {}", (Object)stockData);
            if (stockData == null || stockData.name() == null) {
                throw new IllegalArgumentException("Invalid data format for stock code " + stockCode);
            }
            return new StockInfo(stockCode, stockData.name(), Double.valueOf(stockData.currentPrice() / 100.0), Double.valueOf(stockData.highPrice() / 100.0), Double.valueOf(stockData.lowPrice() / 100.0), Double.valueOf(stockData.openPrice() / 100.0), Double.valueOf(stockData.volume() / 10000.0), Double.valueOf(stockData.amount() / 1.0E8));
        }
        catch (IllegalArgumentException e) {
            logger.error("Parameter error: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get stock {} information: {}", new Object[]{stockCode, e.getMessage(), e});
            throw new RuntimeException("Failed to get stock " + stockCode + " information: " + e.getMessage());
        }
    }
}

